/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.SerializationHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.logback.SpringProfileAction;
import org.springframework.boot.logging.logback.SpringProfileModel;
import org.springframework.boot.logging.logback.SpringProfileModelHandler;
import org.springframework.boot.logging.logback.SpringPropertyAction;
import org.springframework.boot.logging.logback.SpringPropertyModel;
import org.springframework.boot.logging.logback.SpringPropertyModelHandler;
import org.springframework.core.CollectionFactory;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.SingletonSupplier;

class SpringBootJoranConfigurator
extends JoranConfigurator {
    private LoggingInitializationContext initializationContext;

    SpringBootJoranConfigurator(LoggingInitializationContext initializationContext) {
        this.initializationContext = initializationContext;
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        defaultProcessor.addHandler(SpringPropertyModel.class, (handlerContext, handlerMic) -> new SpringPropertyModelHandler(this.context, this.initializationContext.getEnvironment()));
        defaultProcessor.addHandler(SpringProfileModel.class, (handlerContext, handlerMic) -> new SpringProfileModelHandler(this.context, this.initializationContext.getEnvironment()));
        super.addModelHandlerAssociations(defaultProcessor);
    }

    public void addElementSelectorAndActionAssociations(RuleStore ruleStore) {
        super.addElementSelectorAndActionAssociations(ruleStore);
        ruleStore.addRule(new ElementSelector("configuration/springProperty"), SpringPropertyAction::new);
        ruleStore.addRule(new ElementSelector("*/springProfile"), SpringProfileAction::new);
        ruleStore.addTransparentPathPart("springProfile");
    }

    boolean configureUsingAotGeneratedArtifacts() {
        if (!new PatternRules(this.getContext()).load()) {
            return false;
        }
        Model model = new ModelReader().read();
        this.processModel(model);
        this.registerSafeConfiguration(model);
        return true;
    }

    public void processModel(Model model) {
        super.processModel(model);
        if (!NativeDetector.inNativeImage() && this.isAotProcessingInProgress()) {
            this.getContext().putObject(BeanFactoryInitializationAotContribution.class.getName(), (Object)new LogbackConfigurationAotContribution(model, this.getModelInterpretationContext(), this.getContext()));
        }
    }

    private boolean isAotProcessingInProgress() {
        return Boolean.getBoolean("spring.aot.processing");
    }

    private static final class PatternRules {
        private static final String RESOURCE_LOCATION = "META-INF/spring/logback-pattern-rules";
        private final Context context;

        private PatternRules(Context context) {
            this.context = context;
        }

        private boolean load() {
            try {
                ClassPathResource resource = new ClassPathResource(RESOURCE_LOCATION);
                if (!resource.exists()) {
                    return false;
                }
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                Map<String, String> patternRuleRegistry = this.getRegistryMap();
                for (String word : properties.stringPropertyNames()) {
                    patternRuleRegistry.put(word, properties.getProperty(word));
                }
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private Map<String, String> getRegistryMap() {
            HashMap patternRuleRegistry = (HashMap)this.context.getObject("PATTERN_RULE_REGISTRY");
            if (patternRuleRegistry == null) {
                patternRuleRegistry = new HashMap();
                this.context.putObject("PATTERN_RULE_REGISTRY", patternRuleRegistry);
            }
            return patternRuleRegistry;
        }

        private void save(GenerationContext generationContext) {
            Map<String, String> registryMap = this.getRegistryMap();
            generationContext.getGeneratedFiles().addResourceFile(RESOURCE_LOCATION, () -> this.asInputStream(registryMap));
            generationContext.getRuntimeHints().resources().registerPattern(RESOURCE_LOCATION);
            for (String ruleClassName : registryMap.values()) {
                generationContext.getRuntimeHints().reflection().registerType(TypeReference.of((String)ruleClassName), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
            }
        }

        private InputStream asInputStream(Map<String, String> patternRuleRegistry) {
            Properties properties = CollectionFactory.createSortedProperties((boolean)true);
            patternRuleRegistry.forEach(properties::setProperty);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try {
                properties.store(bytes, "");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return new ByteArrayInputStream(bytes.toByteArray());
        }
    }

    private static final class ModelReader {
        private ModelReader() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Model read() {
            try (InputStream modelInput = this.getClass().getClassLoader().getResourceAsStream("META-INF/spring/logback-model");){
                Model model;
                try (ObjectInputStream input = new ObjectInputStream(modelInput);){
                    Model model2 = (Model)input.readObject();
                    ModelUtil.resetForReuse((Model)model2);
                    model = model2;
                }
                return model;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to load model from 'META-INF/spring/logback-model'", ex);
            }
        }
    }

    static final class LogbackConfigurationAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final ModelWriter modelWriter;
        private final PatternRules patternRules;

        private LogbackConfigurationAotContribution(Model model, ModelInterpretationContext interpretationContext, Context context) {
            this.modelWriter = new ModelWriter(model, interpretationContext);
            this.patternRules = new PatternRules(context);
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            this.modelWriter.writeTo(generationContext);
            this.patternRules.save(generationContext);
        }
    }

    private static final class ModelWriter {
        private static final String MODEL_RESOURCE_LOCATION = "META-INF/spring/logback-model";
        private final Model model;
        private final ModelInterpretationContext modelInterpretationContext;

        private ModelWriter(Model model, ModelInterpretationContext modelInterpretationContext) {
            this.model = model;
            this.modelInterpretationContext = modelInterpretationContext;
        }

        private void writeTo(GenerationContext generationContext) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (ObjectOutputStream output = new ObjectOutputStream(bytes);){
                output.writeObject(this.model);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            ByteArrayResource modelResource = new ByteArrayResource(bytes.toByteArray());
            generationContext.getGeneratedFiles().addResourceFile(MODEL_RESOURCE_LOCATION, (InputStreamSource)modelResource);
            generationContext.getRuntimeHints().resources().registerPattern(MODEL_RESOURCE_LOCATION);
            SerializationHints serializationHints = generationContext.getRuntimeHints().serialization();
            this.serializationTypes(this.model).forEach(arg_0 -> ((SerializationHints)serializationHints).registerType(arg_0));
            this.reflectionTypes(this.model).forEach(type -> generationContext.getRuntimeHints().reflection().registerType(TypeReference.of((String)type), new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS}));
        }

        private Set<Class<? extends Serializable>> serializationTypes(Model model) {
            HashSet<Class<? extends Serializable>> modelClasses = new HashSet<Class<? extends Serializable>>();
            Class<?> candidate = model.getClass();
            while (Model.class.isAssignableFrom(candidate)) {
                if (!modelClasses.add(candidate)) continue;
                ReflectionUtils.doWithFields(candidate, field -> {
                    Class<?> fieldType;
                    if (Modifier.isStatic(field.getModifiers())) {
                        return;
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    Object value = field.get(model);
                    if (value != null && Serializable.class.isAssignableFrom(fieldType = value.getClass())) {
                        modelClasses.add(fieldType);
                    }
                });
                candidate = candidate.getSuperclass();
            }
            for (Model submodel : model.getSubModels()) {
                modelClasses.addAll(this.serializationTypes(submodel));
            }
            return modelClasses;
        }

        private Set<String> reflectionTypes(Model model) {
            return this.reflectionTypes(model, () -> null);
        }

        private Set<String> reflectionTypes(Model model, Supplier<Object> parent) {
            HashSet<String> reflectionTypes = new HashSet<String>();
            Class<?> componentType = this.determineType(model, parent);
            if (componentType != null) {
                this.processComponent(componentType, reflectionTypes);
            }
            SingletonSupplier componentSupplier = SingletonSupplier.ofNullable(() -> this.instantiate(componentType));
            for (Model submodel : model.getSubModels()) {
                reflectionTypes.addAll(this.reflectionTypes(submodel, (Supplier<Object>)componentSupplier));
            }
            return reflectionTypes;
        }

        private Class<?> determineType(Model model, Supplier<Object> parentSupplier) {
            String className;
            if (model instanceof ComponentModel) {
                ComponentModel componentModel = (ComponentModel)model;
                v0 = componentModel.getClassName();
            } else {
                v0 = className = null;
            }
            if (className != null) {
                return this.loadImportType(className);
            }
            String tag = model.getTag();
            if (tag != null) {
                className = this.modelInterpretationContext.getDefaultNestedComponentRegistry().findDefaultComponentTypeByTag(tag);
                if (className != null) {
                    return this.loadImportType(className);
                }
                return this.inferTypeFromParent(parentSupplier, tag);
            }
            return null;
        }

        private Class<?> loadImportType(String className) {
            return this.loadComponentType(this.modelInterpretationContext.getImport(className));
        }

        private Class<?> inferTypeFromParent(Supplier<Object> parentSupplier, String tag) {
            Object parent = parentSupplier.get();
            if (parent != null) {
                try {
                    PropertySetter propertySetter = new PropertySetter(this.modelInterpretationContext.getBeanDescriptionCache(), parent);
                    Class typeFromPropertySetter = propertySetter.getClassNameViaImplicitRules(tag, AggregationType.AS_COMPLEX_PROPERTY, this.modelInterpretationContext.getDefaultNestedComponentRegistry());
                    return typeFromPropertySetter;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }

        private Class<?> loadComponentType(String componentType) {
            try {
                return ClassUtils.forName((String)componentType, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to load component type '" + componentType + "'", ex);
            }
        }

        private Object instantiate(Class<?> type) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                return null;
            }
        }

        private void processComponent(Class<?> componentType, Set<String> reflectionTypes) {
            BeanDescription beanDescription = this.modelInterpretationContext.getBeanDescriptionCache().getBeanDescription(componentType);
            reflectionTypes.addAll(this.parameterTypesNames(beanDescription.getPropertyNameToAdder().values()));
            reflectionTypes.addAll(this.parameterTypesNames(beanDescription.getPropertyNameToSetter().values()));
            reflectionTypes.add(componentType.getCanonicalName());
        }

        private Collection<String> parameterTypesNames(Collection<Method> methods) {
            return methods.stream().filter(method -> !method.getDeclaringClass().equals(ContextAware.class) && !method.getDeclaringClass().equals(ContextAwareBase.class)).map(Method::getParameterTypes).flatMap(Stream::of).filter(type -> !type.isPrimitive() && !type.equals(String.class)).map(Class::getName).toList();
        }
    }
}

