/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry.endpoint;

import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ManagedResource(description="Can be used to display and set the service instance status using the service registry")
public class ServiceRegistryEndpoint
implements MvcEndpoint {
    private final ServiceRegistry serviceRegistry;
    private Registration registration;

    public ServiceRegistryEndpoint(ServiceRegistry<?> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    @RequestMapping(path={"instance-status"}, method={RequestMethod.POST})
    @ResponseBody
    @ManagedOperation
    public ResponseEntity<?> setStatus(@RequestBody String status) {
        Assert.notNull((Object)status, (String)"status may not by null");
        if (this.registration == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)"no registration found");
        }
        this.serviceRegistry.setStatus(this.registration, status);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(path={"instance-status"}, method={RequestMethod.GET})
    @ResponseBody
    @ManagedAttribute
    public ResponseEntity getStatus() {
        if (this.registration == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)"no registration found");
        }
        return ResponseEntity.ok().body(this.serviceRegistry.getStatus(this.registration));
    }

    public String getPath() {
        return "/service-registry";
    }

    public boolean isSensitive() {
        return true;
    }

    public Class<? extends Endpoint<?>> getEndpointType() {
        return null;
    }
}

