/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.core.OrderComparator;

public class CompositeEnvironmentRepository
implements EnvironmentRepository {
    protected List<EnvironmentRepository> environmentRepositories;

    public CompositeEnvironmentRepository(List<EnvironmentRepository> environmentRepositories) {
        Collections.sort(environmentRepositories, OrderComparator.INSTANCE);
        this.environmentRepositories = environmentRepositories;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        Environment env = new Environment(application, new String[]{profile}, label, null, null);
        if (this.environmentRepositories.size() == 1) {
            Environment envRepo = this.environmentRepositories.get(0).findOne(application, profile, label);
            env.addAll(envRepo.getPropertySources());
            env.setVersion(envRepo.getVersion());
            env.setState(envRepo.getState());
        } else {
            for (EnvironmentRepository repo : this.environmentRepositories) {
                env.addAll(repo.findOne(application, profile, label).getPropertySources());
            }
        }
        return env;
    }
}

