/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.credhub.support.CredentialDetails;
import org.springframework.credhub.support.CredentialName;
import org.springframework.credhub.support.SimpleCredentialName;
import org.springframework.credhub.support.json.JsonCredential;
import org.springframework.util.StringUtils;

public class CredhubEnvironmentRepository
implements EnvironmentRepository {
    private CredHubOperations credHubOperations;

    public CredhubEnvironmentRepository(CredHubOperations credHubOperations) {
        this.credHubOperations = credHubOperations;
    }

    @Override
    public Environment findOne(String application, String profilesList, String label) {
        if (StringUtils.isEmpty((Object)profilesList)) {
            profilesList = "default";
        }
        if (StringUtils.isEmpty((Object)label)) {
            label = "master";
        }
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profilesList);
        Environment environment = new Environment(application, profiles, label, null, null);
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        for (String profile : profiles) {
            properties.putAll(this.findProperties(application, profile, label));
        }
        environment.add(new PropertySource("credhub-" + application, properties));
        return environment;
    }

    private Map<Object, Object> findProperties(String application, String profile, String label) {
        String path = "/" + application + "/" + profile + "/" + label;
        return this.credHubOperations.credentials().findByPath(path).stream().map(credentialSummary -> credentialSummary.getName().getName()).map(name -> this.credHubOperations.credentials().getByName((CredentialName)new SimpleCredentialName(new String[]{name}), JsonCredential.class)).map(CredentialDetails::getValue).flatMap(jsonCredential -> jsonCredential.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b));
    }
}

