/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class GenericResourceRepository
implements ResourceRepository,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(GenericResourceRepository.class);
    private ResourceLoader resourceLoader;
    private SearchPathLocator service;

    public GenericResourceRepository(SearchPathLocator service) {
        this.service = service;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public synchronized Resource findOne(String application, String profile, String label, String path) {
        if (StringUtils.hasText((String)path)) {
            String[] locations = this.service.getLocations(application, profile, label).getLocations();
            try {
                int i = locations.length;
                while (i-- > 0) {
                    String location = locations[i];
                    for (String local : this.getProfilePaths(profile, path)) {
                        Resource file;
                        if (this.isInvalidPath(local) || this.isInvalidEncodedPath(local) || !(file = this.resourceLoader.getResource(location).createRelative(local)).exists() || !file.isReadable()) continue;
                        return file;
                    }
                }
            }
            catch (IOException e) {
                throw new NoSuchResourceException("Error : " + path + ". (" + e.getMessage() + ")");
            }
        }
        throw new NoSuchResourceException("Not found: " + path);
    }

    private Collection<String> getProfilePaths(String profiles, String path) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (String profile : StringUtils.commaDelimitedListToSet((String)profiles)) {
            if (!StringUtils.hasText((String)profile) || "default".equals(profile)) {
                paths.add(path);
                continue;
            }
            String ext = StringUtils.getFilenameExtension((String)path);
            String file = path;
            if (ext != null) {
                ext = "." + ext;
                file = StringUtils.stripFilenameExtension((String)path);
            } else {
                ext = "";
            }
            paths.add(file + "-" + profile + ext);
        }
        paths.add(path);
        return paths;
    }

    private boolean isInvalidEncodedPath(String path) {
        if (path.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                if (this.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (this.isInvalidPath(decodedPath = this.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected String processPath(String path) {
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        path = this.cleanDuplicateSlashes(path);
        return this.cleanLeadingSlash(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i = 0; i < path.length(); ++i) {
            char curr = path.charAt(i);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            return slash ? "/" + path.substring(i) : path.substring(i);
        }
        return slash ? "/" : "";
    }

    protected boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Path with \"WEB-INF\" or \"META-INF\": [" + path + "]"));
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Path represents URL or has \"url:\" prefix: [" + path + "]"));
                }
                return true;
            }
        }
        if (path.contains("..") && StringUtils.cleanPath((String)path).contains("../")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Path contains \"../\" after call to StringUtils#cleanPath: [" + path + "]"));
            }
            return true;
        }
        return false;
    }
}

