/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.core;

import java.util.function.Function;
import org.springframework.cloud.function.core.Isolated;
import org.springframework.util.ClassUtils;

public class IsolatedFunction<S, T>
implements Function<S, T>,
Isolated {
    private final Function<S, T> function;
    private final ClassLoader classLoader;

    public IsolatedFunction(Function<S, T> function) {
        this.function = function;
        this.classLoader = function.getClass().getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T apply(S item) {
        ClassLoader context = ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.classLoader);
        try {
            T t = this.function.apply(item);
            return t;
        }
        finally {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)context);
        }
    }
}

