/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.NettyPipeline;
import reactor.netty.http.client.HttpClient;

public class NettyRoutingFilter
implements GlobalFilter,
Ordered {
    private static final Log log = LogFactory.getLog(NettyRoutingFilter.class);
    private final HttpClient httpClient;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private final HttpClientProperties properties;
    private volatile List<HttpHeadersFilter> headersFilters;

    public NettyRoutingFilter(HttpClient httpClient, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider, HttpClientProperties properties) {
        this.httpClient = httpClient;
        this.headersFiltersProvider = headersFiltersProvider;
        this.properties = properties;
    }

    public List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = (List)this.headersFiltersProvider.getIfAvailable();
        }
        return this.headersFilters;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"http".equals(scheme) && !"https".equals(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethodValue());
        String url = requestUrl.toString();
        HttpHeaders filtered = HttpHeadersFilter.filterRequest(this.getHeadersFilters(), exchange);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        filtered.forEach((arg_0, arg_1) -> ((DefaultHttpHeaders)httpHeaders).set(arg_0, arg_1));
        String transferEncoding = request.getHeaders().getFirst("Transfer-Encoding");
        boolean chunkedTransfer = "chunked".equalsIgnoreCase(transferEncoding);
        boolean preserveHost = (Boolean)exchange.getAttributeOrDefault(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, (Object)false);
        Flux responseFlux = ((HttpClient.RequestSender)this.httpClient.chunkedTransfer(chunkedTransfer).request(method).uri(url)).send((req, nettyOutbound) -> {
            req.headers((io.netty.handler.codec.http.HttpHeaders)httpHeaders);
            if (preserveHost) {
                String host = request.getHeaders().getFirst("Host");
                req.header((CharSequence)"Host", (CharSequence)host);
            }
            if (log.isTraceEnabled()) {
                nettyOutbound.withConnection(connection -> log.trace((Object)("outbound route: " + connection.channel().id().asShortText() + ", inbound: " + exchange.getLogPrefix())));
            }
            return nettyOutbound.options(NettyPipeline.SendOptions::flushOnEach).send((Publisher)request.getBody().map(dataBuffer -> ((NettyDataBuffer)dataBuffer).getNativeBuffer()));
        }).responseConnection((res, connection) -> {
            HttpStatus status;
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR, res);
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR, connection);
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = new HttpHeaders();
            res.responseHeaders().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
            String contentTypeValue = headers.getFirst("Content-Type");
            if (StringUtils.hasLength((String)contentTypeValue)) {
                exchange.getAttributes().put("original_response_content_type", contentTypeValue);
            }
            if ((status = HttpStatus.resolve((int)res.status().code())) != null) {
                response.setStatusCode(status);
            } else if (response instanceof AbstractServerHttpResponse) {
                ((AbstractServerHttpResponse)response).setStatusCodeValue(Integer.valueOf(res.status().code()));
            } else {
                throw new IllegalStateException("Unable to set status code on response: " + res.status().code() + ", " + response.getClass());
            }
            HttpHeaders filteredResponseHeaders = HttpHeadersFilter.filter(this.getHeadersFilters(), headers, exchange, HttpHeadersFilter.Type.RESPONSE);
            if (!filteredResponseHeaders.containsKey((Object)"Transfer-Encoding") && filteredResponseHeaders.containsKey((Object)"Content-Length")) {
                response.getHeaders().remove((Object)"Transfer-Encoding");
            }
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_HEADER_NAMES, filteredResponseHeaders.keySet());
            response.getHeaders().putAll((Map)filteredResponseHeaders);
            return Mono.just((Object)res);
        });
        if (this.properties.getResponseTimeout() != null) {
            responseFlux = responseFlux.timeout(this.properties.getResponseTimeout(), (Publisher)Mono.error((Throwable)new TimeoutException("Response took longer than timeout: " + this.properties.getResponseTimeout()))).onErrorMap(TimeoutException.class, th -> new ResponseStatusException(HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th));
        }
        return responseFlux.then(chain.filter(exchange));
    }
}

