/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.event.EnableBodyCachingEvent;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.context.ApplicationEvent;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.retry.Repeat;
import reactor.retry.RepeatContext;
import reactor.retry.Retry;
import reactor.retry.RetryContext;

public class RetryGatewayFilterFactory
extends AbstractGatewayFilterFactory<RetryConfig> {
    public static final String RETRY_ITERATION_KEY = "retry_iteration";
    private static final Log log = LogFactory.getLog(RetryGatewayFilterFactory.class);

    public RetryGatewayFilterFactory() {
        super(RetryConfig.class);
    }

    private static <T> List<T> toList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    @Override
    public GatewayFilter apply(RetryConfig retryConfig) {
        retryConfig.validate();
        Repeat statusCodeRepeat = null;
        if (!retryConfig.getStatuses().isEmpty() || !retryConfig.getSeries().isEmpty()) {
            Predicate<RepeatContext> repeatPredicate = context -> {
                ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
                if (this.exceedsMaxIterations(exchange, retryConfig)) {
                    return false;
                }
                HttpStatus statusCode = exchange.getResponse().getStatusCode();
                boolean retryableStatusCode = retryConfig.getStatuses().contains(statusCode);
                if (!retryableStatusCode && statusCode != null) {
                    retryableStatusCode = retryConfig.getSeries().stream().anyMatch(series -> statusCode.series().equals(series));
                }
                this.trace("retryableStatusCode: %b, statusCode %s, configured statuses %s, configured series %s", retryableStatusCode, statusCode, retryConfig.getStatuses(), retryConfig.getSeries());
                HttpMethod httpMethod = exchange.getRequest().getMethod();
                boolean retryableMethod = retryConfig.getMethods().contains(httpMethod);
                this.trace("retryableMethod: %b, httpMethod %s, configured methods %s", retryableMethod, httpMethod, retryConfig.getMethods());
                return retryableMethod && retryableStatusCode;
            };
            statusCodeRepeat = Repeat.onlyIf(repeatPredicate).doOnRepeat(context -> this.reset((ServerWebExchange)context.applicationContext()));
        }
        Retry exceptionRetry = null;
        if (!retryConfig.getExceptions().isEmpty()) {
            Predicate<RetryContext> retryContextPredicate = context -> {
                if (this.exceedsMaxIterations((ServerWebExchange)context.applicationContext(), retryConfig)) {
                    return false;
                }
                for (Class<? extends Throwable> clazz : retryConfig.getExceptions()) {
                    if (!clazz.isInstance(context.exception())) continue;
                    this.trace("exception is retryable %s, configured exceptions", context.exception().getClass().getName(), retryConfig.getExceptions());
                    return true;
                }
                this.trace("exception is not retryable %s, configured exceptions", context.exception().getClass().getName(), retryConfig.getExceptions());
                return false;
            };
            exceptionRetry = Retry.onlyIf(retryContextPredicate).doOnRetry(context -> this.reset((ServerWebExchange)context.applicationContext())).retryMax((long)retryConfig.getRetries());
        }
        return this.apply(retryConfig.getRouteId(), (Repeat<ServerWebExchange>)statusCodeRepeat, exceptionRetry);
    }

    public boolean exceedsMaxIterations(ServerWebExchange exchange, RetryConfig retryConfig) {
        Integer iteration = (Integer)exchange.getAttribute(RETRY_ITERATION_KEY);
        boolean exceeds = iteration != null && iteration >= retryConfig.getRetries();
        this.trace("exceedsMaxIterations %b, iteration %d, configured retries %d", exceeds, iteration, retryConfig.getRetries());
        return exceeds;
    }

    public void reset(ServerWebExchange exchange) {
        Set addedHeaders = (Set)exchange.getAttributeOrDefault(ServerWebExchangeUtils.CLIENT_RESPONSE_HEADER_NAMES, Collections.emptySet());
        addedHeaders.forEach(header -> exchange.getResponse().getHeaders().remove(header));
        exchange.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_ALREADY_ROUTED_ATTR);
    }

    @Deprecated
    public GatewayFilter apply(Repeat<ServerWebExchange> repeat, Retry<ServerWebExchange> retry) {
        return this.apply(null, repeat, retry);
    }

    public GatewayFilter apply(String routeId, Repeat<ServerWebExchange> repeat, Retry<ServerWebExchange> retry) {
        if (routeId != null && this.getPublisher() != null) {
            this.getPublisher().publishEvent((ApplicationEvent)new EnableBodyCachingEvent(this, routeId));
        }
        return (exchange, chain) -> {
            this.trace("Entering retry-filter", new Object[0]);
            Mono publisher = chain.filter(exchange).doOnSuccessOrError((aVoid, throwable) -> {
                int iteration = (Integer)exchange.getAttributeOrDefault(RETRY_ITERATION_KEY, (Object)-1);
                int newIteration = iteration + 1;
                this.trace("setting new iteration in attr %d", newIteration);
                exchange.getAttributes().put(RETRY_ITERATION_KEY, newIteration);
            });
            if (retry != null) {
                publisher = publisher.retryWhen((Function)retry.withApplicationContext((Object)exchange));
            }
            if (repeat != null) {
                publisher = publisher.repeatWhen((Function)repeat.withApplicationContext((Object)exchange));
            }
            return Mono.fromDirect((Publisher)publisher);
        };
    }

    private void trace(String message, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format(message, args));
        }
    }

    static /* synthetic */ List access$000(Object[] x0) {
        return RetryGatewayFilterFactory.toList(x0);
    }

    public static class RetryConfig
    implements HasRouteId {
        private String routeId;
        private int retries = 3;
        private List<HttpStatus.Series> series = RetryGatewayFilterFactory.access$000(new HttpStatus.Series[]{HttpStatus.Series.SERVER_ERROR});
        private List<HttpStatus> statuses = new ArrayList<HttpStatus>();
        private List<HttpMethod> methods = RetryGatewayFilterFactory.access$000(new HttpMethod[]{HttpMethod.GET});
        private List<Class<? extends Throwable>> exceptions = RetryGatewayFilterFactory.access$000(new Class[]{IOException.class, TimeoutException.class});

        public RetryConfig allMethods() {
            return this.setMethods(HttpMethod.values());
        }

        public void validate() {
            Assert.isTrue((this.retries > 0 ? 1 : 0) != 0, (String)"retries must be greater than 0");
            Assert.isTrue((!this.series.isEmpty() || !this.statuses.isEmpty() || !this.exceptions.isEmpty() ? 1 : 0) != 0, (String)"series, status and exceptions may not all be empty");
            Assert.notEmpty(this.methods, (String)"methods may not be empty");
        }

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }

        public int getRetries() {
            return this.retries;
        }

        public RetryConfig setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public List<HttpStatus.Series> getSeries() {
            return this.series;
        }

        public RetryConfig setSeries(HttpStatus.Series ... series) {
            this.series = Arrays.asList(series);
            return this;
        }

        public List<HttpStatus> getStatuses() {
            return this.statuses;
        }

        public RetryConfig setStatuses(HttpStatus ... statuses) {
            this.statuses = Arrays.asList(statuses);
            return this;
        }

        public List<HttpMethod> getMethods() {
            return this.methods;
        }

        public RetryConfig setMethods(HttpMethod ... methods) {
            this.methods = Arrays.asList(methods);
            return this;
        }

        public List<Class<? extends Throwable>> getExceptions() {
            return this.exceptions;
        }

        public RetryConfig setExceptions(Class<? extends Throwable> ... exceptions) {
            this.exceptions = Arrays.asList(exceptions);
            return this;
        }
    }
}

