/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;

public final class NameUtils {
    public static final String GENERATED_NAME_PREFIX = "_genkey_";

    private NameUtils() {
        throw new AssertionError((Object)"Must not instantiate utility class.");
    }

    public static String generateName(int i) {
        return GENERATED_NAME_PREFIX + i;
    }

    public static String normalizeRoutePredicateName(Class<? extends RoutePredicateFactory> clazz) {
        return NameUtils.removeGarbage(clazz.getSimpleName().replace(RoutePredicateFactory.class.getSimpleName(), ""));
    }

    public static String normalizeFilterFactoryName(Class<? extends GatewayFilterFactory> clazz) {
        return NameUtils.removeGarbage(clazz.getSimpleName().replace(GatewayFilterFactory.class.getSimpleName(), ""));
    }

    private static String removeGarbage(String s) {
        int garbageIdx = s.indexOf("$Mockito");
        if (garbageIdx > 0) {
            return s.substring(0, garbageIdx);
        }
        return s;
    }
}

