/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.support.ServiceUnavailableException;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.web.reactive.DispatcherHandler;
import reactor.core.publisher.Mono;

public class SpringCloudCircuitBreakerResilience4JFilterFactory
extends SpringCloudCircuitBreakerFilterFactory {
    public SpringCloudCircuitBreakerResilience4JFilterFactory(ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandlerProvider) {
        super(reactiveCircuitBreakerFactory, dispatcherHandlerProvider);
    }

    @Override
    protected Mono<Void> handleErrorWithoutFallback(Throwable t) {
        if (java.util.concurrent.TimeoutException.class.isInstance(t)) {
            return Mono.error((Throwable)new TimeoutException());
        }
        if (CallNotPermittedException.class.isInstance(t)) {
            return Mono.error((Throwable)new ServiceUnavailableException());
        }
        return Mono.error((Throwable)t);
    }
}

