/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.http.HttpMethod;
import org.springframework.web.server.ServerWebExchange;

public class MethodRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String METHOD_KEY = "method";

    public MethodRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(METHOD_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange) {
                HttpMethod requestMethod = exchange.getRequest().getMethod();
                return requestMethod == config.getMethod();
            }

            public String toString() {
                return String.format("Method: %s", config.getMethod());
            }
        };
    }

    public static class Config {
        private HttpMethod method;

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

