/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.bind.validation.ValidationBindHandler;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.gateway.support.Configurable;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;

public class ConfigurationService
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;
    private BeanFactory beanFactory;
    private ConversionService conversionService;
    private SpelExpressionParser parser = new SpelExpressionParser();
    private Validator validator;

    @Deprecated
    public ConfigurationService() {
    }

    public ConfigurationService(BeanFactory beanFactory, ConversionService conversionService, Validator validator) {
        this.beanFactory = beanFactory;
        this.conversionService = conversionService;
        this.validator = validator;
    }

    public ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Deprecated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Deprecated
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setParser(SpelExpressionParser parser) {
        this.parser = parser;
    }

    public Validator getValidator() {
        return this.validator;
    }

    @Deprecated
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public <T, C extends Configurable<T> & ShortcutConfigurable> ConfigurableBuilder<T, C> with(C configurable) {
        return new ConfigurableBuilder(this, this, configurable);
    }

    public <T> InstanceBuilder<T> with(T instance) {
        return new InstanceBuilder<T>(this, instance);
    }

    @Deprecated
    public static <T> T bindOrCreate(Bindable<T> bindable, Map<String, Object> properties, String configurationPropertyName, Validator validator, ConversionService conversionService) {
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        if (validator != null) {
            handler = new ValidationBindHandler((BindHandler)handler, new Validator[]{validator});
        }
        List<MapConfigurationPropertySource> propertySources = Collections.singletonList(new MapConfigurationPropertySource(properties));
        return (T)new Binder(propertySources, null, conversionService).bindOrCreate(configurationPropertyName, bindable, (BindHandler)handler);
    }

    @Deprecated
    public static <T> T getTargetObject(Object candidate) {
        try {
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised) {
                return (T)((Advised)candidate).getTargetSource().getTarget();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }

    public abstract class AbstractBuilder<T, B extends AbstractBuilder<T, B>> {
        protected final ConfigurationService service;
        protected BiFunction<T, Map<String, Object>, ApplicationEvent> eventFunction;
        protected String name;
        protected Map<String, Object> normalizedProperties;
        protected Map<String, String> properties;

        public AbstractBuilder(ConfigurationService service) {
            this.service = service;
        }

        protected abstract B getThis();

        public B name(String name) {
            this.name = name;
            return this.getThis();
        }

        public B eventFunction(BiFunction<T, Map<String, Object>, ApplicationEvent> eventFunction) {
            this.eventFunction = eventFunction;
            return this.getThis();
        }

        public B normalizedProperties(Map<String, Object> normalizedProperties) {
            this.normalizedProperties = normalizedProperties;
            return this.getThis();
        }

        public B properties(Map<String, String> properties) {
            this.properties = properties;
            return this.getThis();
        }

        protected abstract void validate();

        protected Map<String, Object> normalizeProperties() {
            HashMap<String, Object> normalizedProperties = new HashMap<String, Object>();
            this.properties.forEach(normalizedProperties::put);
            return normalizedProperties;
        }

        protected abstract T doBind();

        public T bind() {
            this.validate();
            Assert.hasText((String)this.name, (String)"name may not be empty");
            Assert.isTrue((this.properties != null || this.normalizedProperties != null ? 1 : 0) != 0, (String)"properties and normalizedProperties both may not be null");
            if (this.normalizedProperties == null) {
                this.normalizedProperties = this.normalizeProperties();
            }
            T bound = this.doBind();
            if (this.eventFunction != null && this.service.publisher != null) {
                ApplicationEvent applicationEvent = this.eventFunction.apply(bound, this.normalizedProperties);
                this.service.publisher.publishEvent(applicationEvent);
            }
            return bound;
        }
    }

    public class InstanceBuilder<T>
    extends AbstractBuilder<T, InstanceBuilder<T>> {
        private final T instance;

        public InstanceBuilder(ConfigurationService service, T instance) {
            super(service);
            this.instance = instance;
        }

        @Override
        protected InstanceBuilder<T> getThis() {
            return this;
        }

        @Override
        protected void validate() {
            Assert.notNull(this.instance, (String)"instance may not be null");
        }

        @Override
        protected T doBind() {
            Object toBind = ConfigurationService.getTargetObject(this.instance);
            Bindable bindable = Bindable.ofInstance(toBind);
            return ConfigurationService.bindOrCreate(bindable, this.normalizedProperties, this.name, this.service.validator, this.service.conversionService);
        }
    }

    public static class ConfigurableBuilder<T, C extends Configurable<T> & ShortcutConfigurable>
    extends AbstractBuilder<T, ConfigurableBuilder<T, C>> {
        private final C configurable;
        final /* synthetic */ ConfigurationService this$0;

        public ConfigurableBuilder(ConfigurationService service, C configurable) {
            this.this$0 = this$0;
            super(service);
            this.configurable = configurable;
        }

        @Override
        protected ConfigurableBuilder<T, C> getThis() {
            return this;
        }

        @Override
        protected void validate() {
            Assert.notNull(this.configurable, (String)"configurable may not be null");
        }

        @Override
        protected Map<String, Object> normalizeProperties() {
            if (this.service.beanFactory != null) {
                return ((ShortcutConfigurable)this.configurable).shortcutType().normalize(this.properties, (ShortcutConfigurable)this.configurable, this.service.parser, this.service.beanFactory);
            }
            return super.normalizeProperties();
        }

        @Override
        protected T doBind() {
            Bindable bindable = Bindable.of(this.configurable.getConfigClass());
            Object bound = ConfigurationService.bindOrCreate(bindable, this.normalizedProperties, ((ShortcutConfigurable)this.configurable).shortcutFieldPrefix(), this.service.validator, this.service.conversionService);
            return bound;
        }
    }
}

