/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.util.StringUtils;

public class LoadBalancerServiceInstanceCookieTransformer
implements LoadBalancerRequestTransformer {
    private final LoadBalancerProperties.StickySession stickySessionProperties;

    public LoadBalancerServiceInstanceCookieTransformer(LoadBalancerProperties.StickySession stickySessionProperties) {
        this.stickySessionProperties = stickySessionProperties;
    }

    public HttpRequest transformRequest(HttpRequest request, ServiceInstance instance) {
        if (instance == null) {
            return request;
        }
        String instanceIdCookieName = this.stickySessionProperties.getInstanceIdCookieName();
        if (!StringUtils.hasText((String)instanceIdCookieName)) {
            return request;
        }
        HttpHeaders headers = request.getHeaders();
        ArrayList<String> cookieHeaders = new ArrayList<String>(request.getHeaders().getOrEmpty((Object)"Cookie"));
        String serviceInstanceCookie = new HttpCookie(instanceIdCookieName, instance.getInstanceId()).toString();
        cookieHeaders.add(serviceInstanceCookie);
        headers.put("Cookie", cookieHeaders);
        return request;
    }
}

