/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.atlas;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.metrics.export.Exporter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.metrics.atlas.AtlasExporter;
import org.springframework.cloud.netflix.metrics.atlas.AtlasMetricObserver;
import org.springframework.cloud.netflix.metrics.atlas.AtlasMetricObserverConfigBean;
import org.springframework.cloud.netflix.metrics.atlas.AtlasTagProvider;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricsAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={AtlasMetricObserver.class})
@Import(value={ServoMetricsAutoConfiguration.class})
public class AtlasConfiguration {
    @Autowired(required=false)
    private Collection<AtlasTagProvider> tagProviders;
    @Autowired(required=false)
    @Qualifier(value="atlasRestTemplate")
    private RestTemplate restTemplate = new RestTemplate();

    @Bean
    public AtlasMetricObserverConfigBean atlasObserverConfig() {
        return new AtlasMetricObserverConfigBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public AtlasMetricObserver atlasObserver(AtlasMetricObserverConfigBean atlasObserverConfig) {
        BasicTagList tags = (BasicTagList)BasicTagList.EMPTY;
        if (this.tagProviders != null) {
            for (AtlasTagProvider tagProvider : this.tagProviders) {
                for (Map.Entry<String, String> tag : tagProvider.defaultTags().entrySet()) {
                    if (tag.getValue() == null) continue;
                    tags = tags.copy(tag.getKey(), tag.getValue());
                }
            }
        }
        return new AtlasMetricObserver(atlasObserverConfig, this.restTemplate, (TagList)tags);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MonitorRegistry.class})
    public Exporter exporter(AtlasMetricObserver observer, MonitorRegistry monitorRegistry) {
        return new AtlasExporter(observer, (MetricPoller)new MonitorRegistryMetricPoller(monitorRegistry));
    }
}

