/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignClientsRegistrar;
import org.springframework.context.ApplicationContext;

public class FeignClientBuilder {
    private final ApplicationContext applicationContext;

    public FeignClientBuilder(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> Builder<T> forType(Class<T> type, String name) {
        return new Builder(this.applicationContext, type, name);
    }

    public static class Builder<T> {
        private FeignClientFactoryBean feignClientFactoryBean = new FeignClientFactoryBean();

        private Builder(ApplicationContext applicationContext, Class<T> type, String name) {
            this.feignClientFactoryBean.setApplicationContext(applicationContext);
            this.feignClientFactoryBean.setType(type);
            this.feignClientFactoryBean.setName(FeignClientsRegistrar.getName(name));
            this.feignClientFactoryBean.setContextId(FeignClientsRegistrar.getName(name));
            this.url("").path("").decode404(false).fallback(Void.TYPE).fallbackFactory(Void.TYPE);
        }

        public Builder url(String url) {
            this.feignClientFactoryBean.setUrl(FeignClientsRegistrar.getUrl(url));
            return this;
        }

        public Builder contextId(String contextId) {
            this.feignClientFactoryBean.setContextId(contextId);
            return this;
        }

        public Builder path(String path) {
            this.feignClientFactoryBean.setPath(FeignClientsRegistrar.getPath(path));
            return this;
        }

        public Builder decode404(boolean decode404) {
            this.feignClientFactoryBean.setDecode404(decode404);
            return this;
        }

        public Builder fallback(Class<T> fallback) {
            FeignClientsRegistrar.validateFallback(fallback);
            this.feignClientFactoryBean.setFallback(fallback);
            return this;
        }

        public Builder fallbackFactory(Class<T> fallbackFactory) {
            FeignClientsRegistrar.validateFallbackFactory(fallbackFactory);
            this.feignClientFactoryBean.setFallbackFactory(fallbackFactory);
            return this;
        }

        public <T> T build() {
            return this.feignClientFactoryBean.getTarget();
        }
    }
}

