/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.ribbon;

import feign.Client;
import feign.hc5.ApacheHttp5Client;
import org.apache.hc.client5.http.classic.HttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.clientconfig.HttpClient5FeignConfiguration;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ApacheHttp5Client.class})
@ConditionalOnProperty(value={"feign.httpclient.hc5.enabled"}, havingValue="true")
@Import(value={HttpClient5FeignConfiguration.class})
class HttpClient5FeignLoadBalancedConfiguration {
    HttpClient5FeignLoadBalancedConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={Client.class})
    public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory, HttpClient httpClient5) {
        ApacheHttp5Client delegate = new ApacheHttp5Client(httpClient5);
        return new LoadBalancerFeignClient((Client)delegate, cachingFactory, clientFactory);
    }
}

