/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.codec.EncodeException;
import feign.form.multipart.AbstractWriter;
import feign.form.multipart.Output;
import feign.form.util.PojoUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;
import org.springframework.http.MediaType;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractFormWriter
extends AbstractWriter {
    public boolean isApplicable(Object object) {
        return !this.isTypeOrCollection(object, o -> o instanceof MultipartFile) && this.isTypeOrCollection(object, PojoUtil::isUserPojo);
    }

    public void write(Output output, String key, Object object) throws EncodeException {
        try {
            String string = "Content-Disposition: form-data; name=\"" + key + '\"' + "\r\n" + "Content-Type: " + this.getContentType() + "; charset=" + output.getCharset().name() + "\r\n" + "\r\n" + this.writeAsString(object);
            output.write(string);
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage());
        }
    }

    protected abstract MediaType getContentType();

    protected abstract String writeAsString(Object var1) throws IOException;

    private boolean isTypeOrCollection(Object object, Predicate<Object> isType) {
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            return array.length > 1 && isType.test(array[0]);
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            Iterator iterator = iterable.iterator();
            return iterator.hasNext() && isType.test(iterator.next());
        }
        return isType.test(object);
    }
}

