/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Contract;
import feign.ExceptionPropagationPolicy;
import feign.Logger;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="feign.client")
public class FeignClientProperties {
    private boolean defaultToProperties = true;
    private String defaultConfig = "default";
    private Map<String, FeignClientConfiguration> config = new HashMap<String, FeignClientConfiguration>();
    private boolean decodeSlash = true;

    public boolean isDefaultToProperties() {
        return this.defaultToProperties;
    }

    public void setDefaultToProperties(boolean defaultToProperties) {
        this.defaultToProperties = defaultToProperties;
    }

    public String getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(String defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public Map<String, FeignClientConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, FeignClientConfiguration> config) {
        this.config = config;
    }

    public boolean isDecodeSlash() {
        return this.decodeSlash;
    }

    public void setDecodeSlash(boolean decodeSlash) {
        this.decodeSlash = decodeSlash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeignClientProperties that = (FeignClientProperties)o;
        return this.defaultToProperties == that.defaultToProperties && Objects.equals(this.defaultConfig, that.defaultConfig) && Objects.equals(this.config, that.config) && Objects.equals(this.decodeSlash, that.decodeSlash);
    }

    public int hashCode() {
        return Objects.hash(this.defaultToProperties, this.defaultConfig, this.config, this.decodeSlash);
    }

    public static class FeignClientConfiguration {
        private Logger.Level loggerLevel;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Class<Retryer> retryer;
        private Class<ErrorDecoder> errorDecoder;
        private List<Class<RequestInterceptor>> requestInterceptors;
        private Map<String, Collection<String>> defaultRequestHeaders;
        private Map<String, Collection<String>> defaultQueryParameters;
        private Boolean decode404;
        private Class<Decoder> decoder;
        private Class<Encoder> encoder;
        private Class<Contract> contract;
        private ExceptionPropagationPolicy exceptionPropagationPolicy;
        private Boolean followRedirects;

        public Logger.Level getLoggerLevel() {
            return this.loggerLevel;
        }

        public void setLoggerLevel(Logger.Level loggerLevel) {
            this.loggerLevel = loggerLevel;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Class<Retryer> getRetryer() {
            return this.retryer;
        }

        public void setRetryer(Class<Retryer> retryer) {
            this.retryer = retryer;
        }

        public Class<ErrorDecoder> getErrorDecoder() {
            return this.errorDecoder;
        }

        public void setErrorDecoder(Class<ErrorDecoder> errorDecoder) {
            this.errorDecoder = errorDecoder;
        }

        public List<Class<RequestInterceptor>> getRequestInterceptors() {
            return this.requestInterceptors;
        }

        public void setRequestInterceptors(List<Class<RequestInterceptor>> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
        }

        public Map<String, Collection<String>> getDefaultRequestHeaders() {
            return this.defaultRequestHeaders;
        }

        public void setDefaultRequestHeaders(Map<String, Collection<String>> defaultRequestHeaders) {
            this.defaultRequestHeaders = defaultRequestHeaders;
        }

        public Map<String, Collection<String>> getDefaultQueryParameters() {
            return this.defaultQueryParameters;
        }

        public void setDefaultQueryParameters(Map<String, Collection<String>> defaultQueryParameters) {
            this.defaultQueryParameters = defaultQueryParameters;
        }

        public Boolean getDecode404() {
            return this.decode404;
        }

        public void setDecode404(Boolean decode404) {
            this.decode404 = decode404;
        }

        public Class<Decoder> getDecoder() {
            return this.decoder;
        }

        public void setDecoder(Class<Decoder> decoder) {
            this.decoder = decoder;
        }

        public Class<Encoder> getEncoder() {
            return this.encoder;
        }

        public void setEncoder(Class<Encoder> encoder) {
            this.encoder = encoder;
        }

        public Class<Contract> getContract() {
            return this.contract;
        }

        public void setContract(Class<Contract> contract) {
            this.contract = contract;
        }

        public ExceptionPropagationPolicy getExceptionPropagationPolicy() {
            return this.exceptionPropagationPolicy;
        }

        public void setExceptionPropagationPolicy(ExceptionPropagationPolicy exceptionPropagationPolicy) {
            this.exceptionPropagationPolicy = exceptionPropagationPolicy;
        }

        public Boolean isFollowRedirects() {
            return this.followRedirects;
        }

        public void setFollowRedirects(Boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeignClientConfiguration that = (FeignClientConfiguration)o;
            return this.loggerLevel == that.loggerLevel && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.retryer, that.retryer) && Objects.equals(this.errorDecoder, that.errorDecoder) && Objects.equals(this.requestInterceptors, that.requestInterceptors) && Objects.equals(this.decode404, that.decode404) && Objects.equals(this.encoder, that.encoder) && Objects.equals(this.decoder, that.decoder) && Objects.equals(this.contract, that.contract) && Objects.equals(this.exceptionPropagationPolicy, that.exceptionPropagationPolicy) && Objects.equals(this.defaultRequestHeaders, that.defaultRequestHeaders) && Objects.equals(this.defaultQueryParameters, that.defaultQueryParameters) && Objects.equals(this.followRedirects, that.followRedirects);
        }

        public int hashCode() {
            return Objects.hash(this.loggerLevel, this.connectTimeout, this.readTimeout, this.retryer, this.errorDecoder, this.requestInterceptors, this.decode404, this.encoder, this.decoder, this.contract, this.exceptionPropagationPolicy, this.defaultQueryParameters, this.defaultRequestHeaders, this.followRedirects);
        }
    }
}

