/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import com.netflix.hystrix.HystrixCommand;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.QueryMapEncoder;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.ContentType;
import feign.form.MultipartFormContentProcessor;
import feign.form.multipart.Writer;
import feign.form.spring.SpringFormEncoder;
import feign.hystrix.HystrixFeign;
import feign.optionals.OptionalDecoder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.DefaultFeignLoggerFactory;
import org.springframework.cloud.openfeign.FeignCircuitBreaker;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignFormatterRegistrar;
import org.springframework.cloud.openfeign.FeignLoggerFactory;
import org.springframework.cloud.openfeign.clientconfig.FeignClientConfigurer;
import org.springframework.cloud.openfeign.support.AbstractFormWriter;
import org.springframework.cloud.openfeign.support.FeignEncoderProperties;
import org.springframework.cloud.openfeign.support.PageableSpringEncoder;
import org.springframework.cloud.openfeign.support.PageableSpringQueryMapEncoder;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;

@Configuration(proxyBeanMethods=false)
public class FeignClientsConfiguration {
    @Autowired
    private ObjectFactory<HttpMessageConverters> messageConverters;
    @Autowired(required=false)
    private List<AnnotatedParameterProcessor> parameterProcessors = new ArrayList<AnnotatedParameterProcessor>();
    @Autowired(required=false)
    private List<FeignFormatterRegistrar> feignFormatterRegistrars = new ArrayList<FeignFormatterRegistrar>();
    @Autowired(required=false)
    private Logger logger;
    @Autowired(required=false)
    private SpringDataWebProperties springDataWebProperties;
    @Autowired(required=false)
    private FeignClientProperties feignClientProperties;
    @Autowired(required=false)
    private FeignEncoderProperties encoderProperties;

    @Bean
    @ConditionalOnMissingBean
    public Decoder feignDecoder() {
        return new OptionalDecoder((Decoder)new ResponseEntityDecoder(new SpringDecoder(this.messageConverters)));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.data.domain.Pageable"})
    public Encoder feignEncoder(ObjectProvider<AbstractFormWriter> formWriterProvider) {
        return this.springEncoder(formWriterProvider, this.encoderProperties);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Pageable"})
    @ConditionalOnMissingBean
    public Encoder feignEncoderPageable(ObjectProvider<AbstractFormWriter> formWriterProvider) {
        PageableSpringEncoder encoder = new PageableSpringEncoder(this.springEncoder(formWriterProvider, this.encoderProperties));
        if (this.springDataWebProperties != null) {
            encoder.setPageParameter(this.springDataWebProperties.getPageable().getPageParameter());
            encoder.setSizeParameter(this.springDataWebProperties.getPageable().getSizeParameter());
            encoder.setSortParameter(this.springDataWebProperties.getSort().getSortParameter());
        }
        return encoder;
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.domain.Pageable"})
    @ConditionalOnMissingBean
    public QueryMapEncoder feignQueryMapEncoderPageable() {
        return new PageableSpringQueryMapEncoder();
    }

    @Bean
    @ConditionalOnMissingBean
    public Contract feignContract(ConversionService feignConversionService) {
        boolean decodeSlash = this.feignClientProperties == null || this.feignClientProperties.isDecodeSlash();
        return new SpringMvcContract(this.parameterProcessors, feignConversionService, decodeSlash);
    }

    @Bean
    public FormattingConversionService feignConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        for (FeignFormatterRegistrar feignFormatterRegistrar : this.feignFormatterRegistrars) {
            feignFormatterRegistrar.registerFormatters((FormatterRegistry)conversionService);
        }
        return conversionService;
    }

    @Bean
    @ConditionalOnMissingBean
    public Retryer feignRetryer() {
        return Retryer.NEVER_RETRY;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public Feign.Builder feignBuilder(Retryer retryer) {
        return Feign.builder().retryer(retryer);
    }

    @Bean
    @ConditionalOnMissingBean(value={FeignLoggerFactory.class})
    public FeignLoggerFactory feignLoggerFactory() {
        return new DefaultFeignLoggerFactory(this.logger);
    }

    @Bean
    @ConditionalOnMissingBean(value={FeignClientConfigurer.class})
    public FeignClientConfigurer feignClientConfigurer() {
        return new FeignClientConfigurer(){};
    }

    private Encoder springEncoder(ObjectProvider<AbstractFormWriter> formWriterProvider, FeignEncoderProperties encoderProperties) {
        AbstractFormWriter formWriter = (AbstractFormWriter)((Object)formWriterProvider.getIfAvailable());
        if (formWriter != null) {
            return new SpringEncoder(new SpringPojoFormEncoder(formWriter), this.messageConverters, encoderProperties);
        }
        return new SpringEncoder(new SpringFormEncoder(), this.messageConverters, encoderProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CircuitBreaker.class})
    @ConditionalOnProperty(value={"feign.circuitbreaker.enabled"})
    protected static class CircuitBreakerPresentFeignBuilderConfiguration {
        protected CircuitBreakerPresentFeignBuilderConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnMissingBean(value={Feign.Builder.class, CircuitBreakerFactory.class})
        public Feign.Builder defaultFeignBuilder(Retryer retryer) {
            return Feign.builder().retryer(retryer);
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={CircuitBreakerFactory.class})
        public Feign.Builder circuitBreakerFeignBuilder() {
            return FeignCircuitBreaker.builder();
        }
    }

    private class SpringPojoFormEncoder
    extends SpringFormEncoder {
        SpringPojoFormEncoder(AbstractFormWriter formWriter) {
            MultipartFormContentProcessor processor = (MultipartFormContentProcessor)this.getContentProcessor(ContentType.MULTIPART);
            processor.addFirstWriter((Writer)formWriter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
    protected static class HystrixFeignConfiguration {
        protected HystrixFeignConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"feign.hystrix.enabled"})
        public Feign.Builder feignHystrixBuilder() {
            return HystrixFeign.builder();
        }
    }
}

