/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Feign;
import feign.Target;
import feign.hystrix.FallbackFactory;
import feign.hystrix.HystrixFeign;
import feign.hystrix.SetterFactory;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.util.StringUtils;

class HystrixTargeter
implements Targeter {
    HystrixTargeter() {
    }

    @Override
    public <T> T target(FeignClientFactoryBean factory, Feign.Builder feign, FeignContext context, Target.HardCodedTarget<T> target) {
        Class<?> fallback;
        if (!(feign instanceof HystrixFeign.Builder)) {
            return (T)feign.target(target);
        }
        HystrixFeign.Builder builder = (HystrixFeign.Builder)feign;
        String name = StringUtils.isEmpty((Object)factory.getContextId()) ? factory.getName() : factory.getContextId();
        SetterFactory setterFactory = this.getOptional(name, context, SetterFactory.class);
        if (setterFactory != null) {
            builder.setterFactory(setterFactory);
        }
        if ((fallback = factory.getFallback()) != Void.TYPE) {
            return this.targetWithFallback(name, context, target, builder, fallback);
        }
        Class<?> fallbackFactory = factory.getFallbackFactory();
        if (fallbackFactory != Void.TYPE) {
            return this.targetWithFallbackFactory(name, context, target, builder, fallbackFactory);
        }
        return (T)feign.target(target);
    }

    private <T> T targetWithFallbackFactory(String feignClientName, FeignContext context, Target.HardCodedTarget<T> target, HystrixFeign.Builder builder, Class<?> fallbackFactoryClass) {
        FallbackFactory fallbackFactory = this.getFromContext("fallbackFactory", feignClientName, context, fallbackFactoryClass, FallbackFactory.class);
        return (T)builder.target(target, fallbackFactory);
    }

    private <T> T targetWithFallback(String feignClientName, FeignContext context, Target.HardCodedTarget<T> target, HystrixFeign.Builder builder, Class<?> fallback) {
        T fallbackInstance = this.getFromContext("fallback", feignClientName, context, fallback, target.type());
        return (T)builder.target(target, fallbackInstance);
    }

    private <T> T getFromContext(String fallbackMechanism, String feignClientName, FeignContext context, Class<?> beanType, Class<T> targetType) {
        Object fallbackInstance = context.getInstance(feignClientName, beanType);
        if (fallbackInstance == null) {
            throw new IllegalStateException(String.format("No " + fallbackMechanism + " instance of type %s found for feign client %s", beanType, feignClientName));
        }
        if (!targetType.isAssignableFrom(beanType)) {
            throw new IllegalStateException(String.format("Incompatible " + fallbackMechanism + " instance. Fallback/fallbackFactory of type %s is not assignable to %s for feign client %s", beanType, targetType, feignClientName));
        }
        return (T)fallbackInstance;
    }

    private <T> T getOptional(String feignClientName, FeignContext context, Class<T> beanType) {
        return (T)context.getInstance(feignClientName, beanType);
    }
}

