/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Client;
import feign.hc5.ApacheHttp5Client;
import java.util.List;
import org.apache.hc.client5.http.classic.HttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.clientconfig.HttpClient5FeignConfiguration;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.OnRetryNotEnabledCondition;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ApacheHttp5Client.class})
@ConditionalOnBean(value={BlockingLoadBalancerClient.class})
@ConditionalOnProperty(value={"feign.httpclient.hc5.enabled"}, havingValue="true")
@Import(value={HttpClient5FeignConfiguration.class})
class HttpClient5FeignLoadBalancerConfiguration {
    HttpClient5FeignLoadBalancerConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={OnRetryNotEnabledCondition.class})
    public Client feignClient(BlockingLoadBalancerClient loadBalancerClient, HttpClient httpClient5) {
        ApacheHttp5Client delegate = new ApacheHttp5Client(httpClient5);
        return new FeignBlockingLoadBalancerClient((Client)delegate, loadBalancerClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    @ConditionalOnBean(value={LoadBalancedRetryFactory.class})
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true", matchIfMissing=true)
    public Client feignRetryClient(BlockingLoadBalancerClient loadBalancerClient, HttpClient httpClient5, List<LoadBalancedRetryFactory> loadBalancedRetryFactories) {
        AnnotationAwareOrderComparator.sort(loadBalancedRetryFactories);
        ApacheHttp5Client delegate = new ApacheHttp5Client(httpClient5);
        return new RetryableFeignBlockingLoadBalancerClient((Client)delegate, loadBalancerClient, loadBalancedRetryFactories.get(0));
    }
}

