/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.FeignEncoderProperties;
import org.springframework.cloud.openfeign.support.FeignUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.protobuf.ProtobufHttpMessageConverter;
import org.springframework.web.multipart.MultipartFile;

public class SpringEncoder
implements Encoder {
    private static final Log log = LogFactory.getLog(SpringEncoder.class);
    private final SpringFormEncoder springFormEncoder;
    private final ObjectFactory<HttpMessageConverters> messageConverters;
    private final FeignEncoderProperties encoderProperties;

    public SpringEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        this(new SpringFormEncoder(), messageConverters);
    }

    public SpringEncoder(SpringFormEncoder springFormEncoder, ObjectFactory<HttpMessageConverters> messageConverters) {
        this(springFormEncoder, messageConverters, new FeignEncoderProperties());
    }

    public SpringEncoder(SpringFormEncoder springFormEncoder, ObjectFactory<HttpMessageConverters> messageConverters, FeignEncoderProperties encoderProperties) {
        this.springFormEncoder = springFormEncoder;
        this.messageConverters = messageConverters;
        this.encoderProperties = encoderProperties;
    }

    public void encode(Object requestBody, Type bodyType, RequestTemplate request) throws EncodeException {
        if (requestBody != null) {
            Collection contentTypes = (Collection)request.headers().get("Content-Type");
            MediaType requestContentType = null;
            if (contentTypes != null && !contentTypes.isEmpty()) {
                String type = (String)contentTypes.iterator().next();
                requestContentType = MediaType.valueOf((String)type);
            }
            if (this.isFormRelatedContentType(requestContentType)) {
                this.springFormEncoder.encode(requestBody, bodyType, request);
                return;
            }
            if (bodyType == MultipartFile.class) {
                log.warn((Object)"For MultipartFile to be handled correctly, the 'consumes' parameter of @RequestMapping should be specified as MediaType.MULTIPART_FORM_DATA_VALUE");
            }
            this.encodeWithMessageConverter(requestBody, bodyType, request, requestContentType);
        }
    }

    private void encodeWithMessageConverter(Object requestBody, Type bodyType, RequestTemplate request, MediaType requestContentType) {
        for (HttpMessageConverter messageConverter : ((HttpMessageConverters)this.messageConverters.getObject()).getConverters()) {
            Charset charsetFromContentType;
            FeignOutputMessage outputMessage;
            try {
                outputMessage = messageConverter instanceof GenericHttpMessageConverter ? this.checkAndWrite(requestBody, bodyType, requestContentType, (GenericHttpMessageConverter)messageConverter, request) : this.checkAndWrite(requestBody, requestContentType, messageConverter, request);
            }
            catch (IOException | HttpMessageConversionException ex) {
                throw new EncodeException("Error converting request body", ex);
            }
            if (outputMessage == null) continue;
            request.headers(null);
            request.headers(FeignUtils.getHeaders(outputMessage.getHeaders()));
            MediaType contentType = outputMessage.getHeaders().getContentType();
            Charset charset = charsetFromContentType = contentType != null ? contentType.getCharset() : null;
            Charset charset2 = this.encoderProperties != null && this.encoderProperties.isCharsetFromContentType() && charsetFromContentType != null ? charsetFromContentType : (this.shouldHaveNullCharset(messageConverter, outputMessage) ? null : StandardCharsets.UTF_8);
            request.body(outputMessage.getOutputStream().toByteArray(), charset2);
            return;
        }
        String message = "Could not write request: no suitable HttpMessageConverter found for request type [" + requestBody.getClass().getName() + "]";
        if (requestContentType != null) {
            message = message + " and content type [" + requestContentType + "]";
        }
        throw new EncodeException(message);
    }

    private boolean shouldHaveNullCharset(HttpMessageConverter messageConverter, FeignOutputMessage outputMessage) {
        return this.binaryContentType(outputMessage) || messageConverter instanceof ByteArrayHttpMessageConverter || messageConverter instanceof ProtobufHttpMessageConverter && ProtobufHttpMessageConverter.PROTOBUF.isCompatibleWith(outputMessage.getHeaders().getContentType());
    }

    private FeignOutputMessage checkAndWrite(Object body, MediaType contentType, HttpMessageConverter converter, RequestTemplate request) throws IOException {
        if (converter.canWrite(body.getClass(), contentType)) {
            this.logBeforeWrite(body, contentType, converter);
            FeignOutputMessage outputMessage = new FeignOutputMessage(request);
            converter.write(body, contentType, (HttpOutputMessage)outputMessage);
            return outputMessage;
        }
        return null;
    }

    private FeignOutputMessage checkAndWrite(Object body, Type genericType, MediaType contentType, GenericHttpMessageConverter converter, RequestTemplate request) throws IOException {
        if (converter.canWrite(genericType, body.getClass(), contentType)) {
            this.logBeforeWrite(body, contentType, (HttpMessageConverter)converter);
            FeignOutputMessage outputMessage = new FeignOutputMessage(request);
            converter.write(body, genericType, contentType, (HttpOutputMessage)outputMessage);
            return outputMessage;
        }
        return null;
    }

    private void logBeforeWrite(Object requestBody, MediaType requestContentType, HttpMessageConverter messageConverter) {
        if (log.isDebugEnabled()) {
            if (requestContentType != null) {
                log.debug((Object)("Writing [" + requestBody + "] as \"" + requestContentType + "\" using [" + messageConverter + "]"));
            } else {
                log.debug((Object)("Writing [" + requestBody + "] using [" + messageConverter + "]"));
            }
        }
    }

    private boolean isFormRelatedContentType(MediaType requestContentType) {
        return this.isMultipartType(requestContentType) || this.isFormUrlEncoded(requestContentType);
    }

    private boolean isMultipartType(MediaType requestContentType) {
        return Arrays.asList(MediaType.MULTIPART_FORM_DATA, MediaType.MULTIPART_MIXED, MediaType.MULTIPART_RELATED).contains(requestContentType);
    }

    private boolean isFormUrlEncoded(MediaType requestContentType) {
        return Objects.equals(MediaType.APPLICATION_FORM_URLENCODED, requestContentType);
    }

    private boolean binaryContentType(FeignOutputMessage outputMessage) {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        return contentType == null || Stream.of(MediaType.APPLICATION_CBOR, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_PDF, MediaType.IMAGE_GIF, MediaType.IMAGE_JPEG, MediaType.IMAGE_PNG).anyMatch(mediaType -> mediaType.includes(contentType));
    }

    private final class FeignOutputMessage
    implements HttpOutputMessage {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final HttpHeaders httpHeaders;

        private FeignOutputMessage(RequestTemplate request) {
            this.httpHeaders = FeignUtils.getHttpHeaders(request.headers());
        }

        public OutputStream getBody() throws IOException {
            return this.outputStream;
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

