/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.hateoas;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.rest.RepositoryRestMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.hal.HalMediaTypeConfiguration;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnClass(value={RepresentationModel.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, RepositoryRestMvcAutoConfiguration.class})
public class FeignHalAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={HalMediaTypeConfiguration.class})
    @ConditionalOnMissingBean
    public TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter(ObjectProvider<ObjectMapper> objectMapper, HalMediaTypeConfiguration halConfiguration) {
        ObjectMapper mapper = ((ObjectMapper)objectMapper.getIfAvailable(ObjectMapper::new)).copy();
        halConfiguration.configureObjectMapper(mapper);
        TypeConstrainedMappingJackson2HttpMessageConverter converter = new TypeConstrainedMappingJackson2HttpMessageConverter(RepresentationModel.class);
        converter.setSupportedMediaTypes(Collections.singletonList(MediaTypes.HAL_JSON));
        converter.setObjectMapper(mapper);
        return converter;
    }
}

