/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import com.fasterxml.jackson.databind.Module;
import feign.Capability;
import feign.Client;
import feign.Feign;
import feign.RequestInterceptor;
import feign.Target;
import feign.hc5.ApacheHttp5Client;
import feign.httpclient.ApacheHttpClient;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.cloud.openfeign.CachingCapability;
import org.springframework.cloud.openfeign.CircuitBreakerNameResolver;
import org.springframework.cloud.openfeign.DefaultTargeter;
import org.springframework.cloud.openfeign.FeignCircuitBreakerDisabledConditions;
import org.springframework.cloud.openfeign.FeignCircuitBreakerTargeter;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.HttpClient5DisabledConditions;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.cloud.openfeign.security.OAuth2FeignRequestInterceptor;
import org.springframework.cloud.openfeign.support.FeignEncoderProperties;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.cloud.openfeign.support.PageJacksonModule;
import org.springframework.cloud.openfeign.support.SortJacksonModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Feign.class})
@EnableConfigurationProperties(value={FeignClientProperties.class, FeignHttpClientProperties.class, FeignEncoderProperties.class})
public class FeignAutoConfiguration {
    private static final Log LOG = LogFactory.getLog(FeignAutoConfiguration.class);
    @Autowired(required=false)
    private List<FeignClientSpecification> configurations = new ArrayList<FeignClientSpecification>();

    @Bean
    public HasFeatures feignFeature() {
        return HasFeatures.namedFeature((String)"Feign", Feign.class);
    }

    @Bean
    public FeignContext feignContext() {
        FeignContext context = new FeignContext();
        context.setConfigurations(this.configurations);
        return context;
    }

    @Bean
    @ConditionalOnProperty(value={"feign.cache.enabled"}, matchIfMissing=true)
    @ConditionalOnBean(value={CacheInterceptor.class})
    public Capability cachingCapability(CacheInterceptor cacheInterceptor) {
        return new CachingCapability(cacheInterceptor);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OAuth2ClientContext.class})
    @ConditionalOnProperty(value={"feign.oauth2.enabled"})
    protected static class Oauth2FeignConfiguration {
        protected Oauth2FeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={OAuth2FeignRequestInterceptor.class})
        @ConditionalOnBean(value={OAuth2ClientContext.class, OAuth2ProtectedResourceDetails.class})
        public RequestInterceptor oauth2FeignRequestInterceptor(OAuth2ClientContext oAuth2ClientContext, OAuth2ProtectedResourceDetails resource) {
            return new OAuth2FeignRequestInterceptor(oAuth2ClientContext, resource);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ApacheHttp5Client.class})
    @ConditionalOnMissingBean(value={CloseableHttpClient.class})
    @ConditionalOnProperty(value={"feign.httpclient.hc5.enabled"}, havingValue="true")
    @Import(value={org.springframework.cloud.openfeign.clientconfig.HttpClient5FeignConfiguration.class})
    protected static class HttpClient5FeignConfiguration {
        protected HttpClient5FeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient(CloseableHttpClient httpClient5) {
            return new ApacheHttp5Client((org.apache.hc.client5.http.classic.HttpClient)httpClient5);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={feign.okhttp.OkHttpClient.class})
    @ConditionalOnMissingBean(value={OkHttpClient.class})
    @ConditionalOnProperty(value={"feign.okhttp.enabled"})
    protected static class OkHttpFeignConfiguration {
        private OkHttpClient okHttpClient;

        protected OkHttpFeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ConnectionPool.class})
        public ConnectionPool httpClientConnectionPool(FeignHttpClientProperties httpClientProperties, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
            Integer maxTotalConnections = httpClientProperties.getMaxConnections();
            Long timeToLive = httpClientProperties.getTimeToLive();
            TimeUnit ttlUnit = httpClientProperties.getTimeToLiveUnit();
            return connectionPoolFactory.create(maxTotalConnections.intValue(), timeToLive.longValue(), ttlUnit);
        }

        @Bean
        public OkHttpClient client(OkHttpClientFactory httpClientFactory, ConnectionPool connectionPool, FeignHttpClientProperties httpClientProperties) {
            Boolean followRedirects = httpClientProperties.isFollowRedirects();
            Integer connectTimeout = httpClientProperties.getConnectionTimeout();
            Boolean disableSslValidation = httpClientProperties.isDisableSslValidation();
            this.okHttpClient = httpClientFactory.createBuilder(disableSslValidation.booleanValue()).connectTimeout((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).followRedirects(followRedirects.booleanValue()).connectionPool(connectionPool).build();
            return this.okHttpClient;
        }

        @PreDestroy
        public void destroy() {
            if (this.okHttpClient != null) {
                this.okHttpClient.dispatcher().executorService().shutdown();
                this.okHttpClient.connectionPool().evictAll();
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient(OkHttpClient client) {
            return new feign.okhttp.OkHttpClient(client);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ApacheHttpClient.class})
    @ConditionalOnMissingBean(value={org.apache.http.impl.client.CloseableHttpClient.class})
    @ConditionalOnProperty(value={"feign.httpclient.enabled"}, matchIfMissing=true)
    @Conditional(value={HttpClient5DisabledConditions.class})
    protected static class HttpClientFeignConfiguration {
        private final Timer connectionManagerTimer = new Timer("FeignApacheHttpClientConfiguration.connectionManagerTimer", true);
        @Autowired(required=false)
        private RegistryBuilder registryBuilder;
        private org.apache.http.impl.client.CloseableHttpClient httpClient;

        protected HttpClientFeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={HttpClientConnectionManager.class})
        public HttpClientConnectionManager connectionManager(ApacheHttpClientConnectionManagerFactory connectionManagerFactory, FeignHttpClientProperties httpClientProperties) {
            final HttpClientConnectionManager connectionManager = connectionManagerFactory.newConnectionManager(httpClientProperties.isDisableSslValidation(), httpClientProperties.getMaxConnections(), httpClientProperties.getMaxConnectionsPerRoute(), httpClientProperties.getTimeToLive(), httpClientProperties.getTimeToLiveUnit(), this.registryBuilder);
            this.connectionManagerTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    connectionManager.closeExpiredConnections();
                }
            }, 30000L, (long)httpClientProperties.getConnectionTimerRepeat());
            return connectionManager;
        }

        @Bean
        public org.apache.http.impl.client.CloseableHttpClient httpClient(ApacheHttpClientFactory httpClientFactory, HttpClientConnectionManager httpClientConnectionManager, FeignHttpClientProperties httpClientProperties) {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(httpClientProperties.getConnectionTimeout()).setRedirectsEnabled(httpClientProperties.isFollowRedirects()).build();
            this.httpClient = httpClientFactory.createBuilder().setConnectionManager(httpClientConnectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
            return this.httpClient;
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient(HttpClient httpClient) {
            return new ApacheHttpClient(httpClient);
        }

        @PreDestroy
        public void destroy() {
            block3: {
                this.connectionManagerTimer.cancel();
                if (this.httpClient != null) {
                    try {
                        this.httpClient.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isErrorEnabled()) break block3;
                        LOG.error((Object)"Could not correctly close httpClient.");
                    }
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CircuitBreaker.class})
    @ConditionalOnProperty(value={"feign.circuitbreaker.enabled"}, havingValue="true")
    protected static class CircuitBreakerPresentFeignTargeterConfiguration {
        protected CircuitBreakerPresentFeignTargeterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
        public Targeter defaultFeignTargeter() {
            return new DefaultTargeter();
        }

        @Bean
        @ConditionalOnMissingBean(value={CircuitBreakerNameResolver.class})
        public CircuitBreakerNameResolver circuitBreakerNameResolver() {
            return new DefaultCircuitBreakerNameResolver();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={CircuitBreakerFactory.class})
        public Targeter circuitBreakerFeignTargeter(CircuitBreakerFactory circuitBreakerFactory, @Value(value="${feign.circuitbreaker.group.enabled:false}") boolean circuitBreakerGroupEnabled, CircuitBreakerNameResolver circuitBreakerNameResolver) {
            return new FeignCircuitBreakerTargeter(circuitBreakerFactory, circuitBreakerGroupEnabled, circuitBreakerNameResolver);
        }

        static class DefaultCircuitBreakerNameResolver
        implements CircuitBreakerNameResolver {
            DefaultCircuitBreakerNameResolver() {
            }

            @Override
            public String resolveCircuitBreakerName(String feignClientName, Target<?> target, Method method) {
                return Feign.configKey((Class)target.type(), (Method)method);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={FeignCircuitBreakerDisabledConditions.class})
    protected static class DefaultFeignTargeterConfiguration {
        protected DefaultFeignTargeterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Targeter feignTargeter() {
            return new DefaultTargeter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Module.class, Page.class, Sort.class})
    @ConditionalOnProperty(value={"feign.autoconfiguration.jackson.enabled"}, havingValue="true")
    protected static class FeignJacksonConfiguration {
        protected FeignJacksonConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={PageJacksonModule.class})
        public PageJacksonModule pageJacksonModule() {
            return new PageJacksonModule();
        }

        @Bean
        @ConditionalOnMissingBean(value={SortJacksonModule.class})
        public SortJacksonModule sortModule() {
            return new SortJacksonModule();
        }
    }
}

