/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Request;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class OptionsFactoryBean
implements FactoryBean<Request.Options>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String contextId;
    private Request.Options options;

    public Class<?> getObjectType() {
        return Request.Options.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Request.Options getObject() {
        if (this.options != null) {
            return this.options;
        }
        this.options = new Request.Options();
        FeignClientProperties properties = (FeignClientProperties)this.applicationContext.getBean(FeignClientProperties.class);
        this.options = this.createOptionsWithApplicableValues(properties.getConfig().get(properties.getDefaultConfig()), this.options);
        this.options = this.createOptionsWithApplicableValues(properties.getConfig().get(this.contextId), this.options);
        return this.options;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    private Request.Options createOptionsWithApplicableValues(FeignClientProperties.FeignClientConfiguration clientConfiguration, Request.Options options) {
        if (Objects.isNull(clientConfiguration)) {
            return options;
        }
        int connectTimeoutMillis = Objects.nonNull(clientConfiguration.getConnectTimeout()) ? clientConfiguration.getConnectTimeout().intValue() : options.connectTimeoutMillis();
        int readTimeoutMillis = Objects.nonNull(clientConfiguration.getReadTimeout()) ? clientConfiguration.getReadTimeout().intValue() : options.readTimeoutMillis();
        boolean followRedirects = Objects.nonNull(clientConfiguration.isFollowRedirects()) ? clientConfiguration.isFollowRedirects().booleanValue() : options.isFollowRedirects();
        return new Request.Options((long)connectTimeoutMillis, TimeUnit.MILLISECONDS, (long)readTimeoutMillis, TimeUnit.MILLISECONDS, followRedirects);
    }
}

