/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.RequestParam;

public class RequestParamParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<RequestParam> ANNOTATION = RequestParam.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        int parameterIndex = context.getParameterIndex();
        Class<?> parameterType = method.getParameterTypes()[parameterIndex];
        MethodMetadata data = context.getMethodMetadata();
        if (Map.class.isAssignableFrom(parameterType)) {
            Util.checkState((data.queryMapIndex() == null ? 1 : 0) != 0, (String)"Query map can only be present once.", (Object[])new Object[0]);
            data.queryMapIndex(Integer.valueOf(parameterIndex));
            return true;
        }
        RequestParam requestParam = ANNOTATION.cast(annotation);
        String name = requestParam.value();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"RequestParam.value() was empty on parameter %s of method %s", (Object[])new Object[]{parameterIndex, method.getName()});
        context.setParameterName(name);
        Collection<String> query = context.setTemplateParameter(name, (Collection)data.template().queries().get(name));
        data.template().query(name, query);
        return true;
    }
}

