/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.clientconfig;

import java.net.http.HttpClient;
import java.time.Duration;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.clientconfig.http2client.Http2ClientCustomizer;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={HttpClient.class})
public class Http2ClientFeignConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HttpClient.Builder httpClientBuilder(FeignHttpClientProperties httpClientProperties) {
        return HttpClient.newBuilder().followRedirects(httpClientProperties.isFollowRedirects() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER).version(HttpClient.Version.valueOf(httpClientProperties.getHttp2().getVersion())).connectTimeout(Duration.ofMillis(httpClientProperties.getConnectionTimeout()));
    }

    @Bean
    public HttpClient httpClient(HttpClient.Builder httpClientBuilder, List<Http2ClientCustomizer> customizers) {
        customizers.forEach(customizer -> customizer.customize(httpClientBuilder));
        return httpClientBuilder.build();
    }
}

