/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.querymap.BeanQueryMapEncoder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableSpringQueryMapEncoder
extends BeanQueryMapEncoder {
    private String pageParameter = "page";
    private String sizeParameter = "size";
    private String sortParameter = "sort";

    public void setPageParameter(String pageParameter) {
        this.pageParameter = pageParameter;
    }

    public void setSizeParameter(String sizeParameter) {
        this.sizeParameter = sizeParameter;
    }

    public void setSortParameter(String sortParameter) {
        this.sortParameter = sortParameter;
    }

    public Map<String, Object> encode(Object object) {
        if (this.supports(object)) {
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                if (pageable.isPaged()) {
                    queryMap.put(this.pageParameter, pageable.getPageNumber());
                    queryMap.put(this.sizeParameter, pageable.getPageSize());
                }
                if (pageable.getSort() != null) {
                    this.applySort(queryMap, pageable.getSort());
                }
            } else if (object instanceof Sort) {
                Sort sort = (Sort)object;
                this.applySort(queryMap, sort);
            }
            return queryMap;
        }
        return super.encode(object);
    }

    private void applySort(Map<String, Object> queryMap, Sort sort) {
        ArrayList<CallSite> sortQueries = new ArrayList<CallSite>();
        for (Sort.Order order : sort) {
            sortQueries.add((CallSite)((Object)(order.getProperty() + "%2C" + order.getDirection())));
        }
        if (!sortQueries.isEmpty()) {
            queryMap.put(this.sortParameter, sortQueries);
        }
    }

    protected boolean supports(Object object) {
        return object instanceof Pageable || object instanceof Sort;
    }
}

