/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Tracing;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.KafkaStreamsBuilderFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.messaging.OnMessagingEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@OnMessagingEnabled
@ConditionalOnProperty(value={"spring.sleuth.messaging.kafka.streams.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={KafkaStreams.class})
public class SleuthKafkaStreamsConfiguration {
    protected SleuthKafkaStreamsConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    KafkaStreamsTracing kafkaStreamsTracing(Tracing tracing) {
        return KafkaStreamsTracing.create((Tracing)tracing);
    }

    @Bean
    KafkaStreamsBuilderFactoryBeanPostProcessor kafkaStreamsBuilderFactoryBeanPostProcessor(KafkaStreamsTracing kafkaStreamsTracing) {
        return new KafkaStreamsBuilderFactoryBeanPostProcessor(kafkaStreamsTracing);
    }
}

