/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Span;
import java.util.List;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.sleuth.instrument.messaging.TracingMethodMessageHandlerAdapter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;

class SqsQueueMessageHandler
extends QueueMessageHandler {
    static final String LOGICAL_RESOURCE_ID = "LogicalResourceId";
    private TracingMethodMessageHandlerAdapter handlerAdapter;

    SqsQueueMessageHandler(TracingMethodMessageHandlerAdapter handlerAdapter, List<MessageConverter> messageConverters) {
        super(messageConverters);
        this.handlerAdapter = handlerAdapter;
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        this.handlerAdapter.wrapMethodMessageHandler(message, x$0 -> super.handleMessage(x$0), this::messageSpanTagger);
    }

    private void messageSpanTagger(Span span, Message<?> message) {
        span.remoteServiceName("sqs");
        if (message.getHeaders().get((Object)LOGICAL_RESOURCE_ID) != null) {
            span.tag("sqs.queue_url", message.getHeaders().get((Object)LOGICAL_RESOURCE_ID).toString());
        }
    }
}

