/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.http.HttpClientParser;
import java.net.URI;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

class SleuthHttpClientParser
extends HttpClientParser {
    private static final String HOST_KEY = "http.host";
    private static final String METHOD_KEY = "http.method";
    private static final String PATH_KEY = "http.path";
    private static final String URL_KEY = "http.url";
    private final TraceKeys traceKeys;

    SleuthHttpClientParser(TraceKeys traceKeys) {
        this.traceKeys = traceKeys;
    }

    protected <Req> String spanName(HttpAdapter<Req, ?> adapter, Req req) {
        return this.getName(URI.create(adapter.url(req)));
    }

    public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer) {
        super.request(adapter, req, customizer);
        String url = adapter.url(req);
        URI uri = URI.create(url);
        this.addRequestTags(customizer, url, uri.getHost(), uri.getPath(), adapter.method(req));
        for (String header : this.traceKeys.getHttp().getHeaders()) {
            String headerValue = adapter.requestHeader(req, header);
            if (headerValue == null) continue;
            customizer.tag(this.key(header), headerValue);
        }
    }

    private String key(String key) {
        return this.traceKeys.getHttp().getPrefix() + key.toLowerCase();
    }

    private String getName(URI uri) {
        return SpanNameUtil.shorten(this.uriScheme(uri) + ":" + uri.getRawPath());
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }

    private void addRequestTags(SpanCustomizer customizer, String url, String host, String path, String method) {
        customizer.tag(URL_KEY, url);
        if (host != null) {
            customizer.tag(HOST_KEY, host);
        }
        customizer.tag(PATH_KEY, path);
        customizer.tag(METHOD_KEY, method);
    }
}

