/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

final class TraceWebClientBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    TraceWebClientBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return this.wrapBuilder(webClient.mutate()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return this.wrapBuilder(webClientBuilder);
        }
        return bean;
    }

    private WebClient.Builder wrapBuilder(WebClient.Builder webClientBuilder) {
        return webClientBuilder.filters(this.addTraceExchangeFilterFunctionIfNotPresent());
    }

    private Consumer<List<ExchangeFilterFunction>> addTraceExchangeFilterFunctionIfNotPresent() {
        return functions -> {
            boolean noneMatch = this.noneMatchTraceExchangeFunction((List<ExchangeFilterFunction>)functions);
            if (noneMatch) {
                functions.add(new TraceExchangeFilterFunction(this.beanFactory));
            }
        };
    }

    private boolean noneMatchTraceExchangeFunction(List<ExchangeFilterFunction> functions) {
        for (ExchangeFilterFunction function : functions) {
            if (!(function instanceof TraceExchangeFilterFunction)) continue;
            return false;
        }
        return true;
    }
}

