/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.propagation;

import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.propagation.SleuthTagPropagationProperties;

public class TagPropagationFinishedSpanHandler
extends FinishedSpanHandler {
    private final SleuthProperties sleuthProperties;
    private final SleuthTagPropagationProperties tagPropagationProperties;

    public TagPropagationFinishedSpanHandler(SleuthProperties sleuthProperties, SleuthTagPropagationProperties tagPropagationProperties) {
        this.sleuthProperties = sleuthProperties;
        this.tagPropagationProperties = tagPropagationProperties;
    }

    public boolean handle(TraceContext context, MutableSpan span) {
        for (List strings : Arrays.asList(this.sleuthProperties.getBaggageKeys(), this.sleuthProperties.getPropagationKeys())) {
            for (String key : strings) {
                AbstractMap.SimpleEntry<String, String> entry;
                if (!this.tagPropagationProperties.getWhitelistedKeys().contains(key) || !Objects.nonNull((entry = new AbstractMap.SimpleEntry<String, String>(key, ExtraFieldPropagation.get((TraceContext)context, (String)key))).getValue())) continue;
                span.tag(entry.getKey(), entry.getValue());
            }
        }
        return true;
    }
}

