/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import brave.Span;
import brave.Tracer;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpanParser;
import org.springframework.cloud.sleuth.annotation.SleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.annotation.SpanTagAnnotationHandler;

abstract class AbstractSleuthMethodInvocationProcessor
implements SleuthMethodInvocationProcessor,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(AbstractSleuthMethodInvocationProcessor.class);
    private static final String CLASS_KEY = "class";
    private static final String METHOD_KEY = "method";
    BeanFactory beanFactory;
    private NewSpanParser newSpanParser;
    private Tracer tracer;
    private SpanTagAnnotationHandler spanTagAnnotationHandler;

    AbstractSleuthMethodInvocationProcessor() {
    }

    void before(MethodInvocation invocation, Span span, String log, boolean hasLog) {
        if (hasLog) {
            this.logEvent(span, log + ".before");
        }
        this.spanTagAnnotationHandler().addAnnotatedParameters(invocation);
        this.addTags(invocation, span);
    }

    void after(Span span, boolean isNewSpan, String log, boolean hasLog) {
        if (hasLog) {
            this.logEvent(span, log + ".after");
        }
        if (isNewSpan) {
            span.finish();
        }
    }

    void onFailure(Span span, String log, boolean hasLog, Throwable e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exception occurred while trying to continue the pointcut", e);
        }
        if (hasLog) {
            this.logEvent(span, log + ".afterFailure");
        }
        span.error(e);
    }

    void addTags(MethodInvocation invocation, Span span) {
        span.tag(CLASS_KEY, invocation.getThis().getClass().getSimpleName());
        span.tag(METHOD_KEY, invocation.getMethod().getName());
    }

    void logEvent(Span span, String name) {
        if (span == null) {
            logger.warn((Object)"You were trying to continue a span which was null. Please remember that if two proxied methods are calling each other from the same class then the aspect will not be properly resolved");
            return;
        }
        span.annotate(name);
    }

    String log(ContinueSpan continueSpan) {
        if (continueSpan != null) {
            return continueSpan.log();
        }
        return "";
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    NewSpanParser newSpanParser() {
        if (this.newSpanParser == null) {
            this.newSpanParser = (NewSpanParser)this.beanFactory.getBean(NewSpanParser.class);
        }
        return this.newSpanParser;
    }

    SpanTagAnnotationHandler spanTagAnnotationHandler() {
        if (this.spanTagAnnotationHandler == null) {
            this.spanTagAnnotationHandler = new SpanTagAnnotationHandler(this.beanFactory);
        }
        return this.spanTagAnnotationHandler;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

