/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

class ContextRefreshedListener
extends AtomicBoolean
implements SmartApplicationListener {
    static final Map<BeanFactory, ContextRefreshedListener> CACHE = new ConcurrentHashMap<BeanFactory, ContextRefreshedListener>();
    private static final Log log = LogFactory.getLog(ContextRefreshedListener.class);

    ContextRefreshedListener(boolean initialValue) {
        super(initialValue);
    }

    ContextRefreshedListener() {
        this(false);
    }

    static ContextRefreshedListener getBean(BeanFactory beanFactory) {
        return CACHE.getOrDefault(beanFactory, new ContextRefreshedListener(false));
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ContextRefreshedEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext context;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Context successfully refreshed");
            }
            ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)event;
            ApplicationContext beanFactory = context = contextRefreshedEvent.getApplicationContext();
            if (context instanceof ConfigurableApplicationContext) {
                beanFactory = ((ConfigurableApplicationContext)context).getBeanFactory();
            }
            ContextRefreshedListener listener = CACHE.getOrDefault(beanFactory, this);
            listener.set(true);
            CACHE.put((BeanFactory)beanFactory, listener);
        }
    }
}

