/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.quartz;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContextOrSamplingFlags;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

class TracingJobListener
implements JobListener,
TriggerListener {
    static final String TRIGGER_TAG_KEY = "quartz.trigger";
    static final String CONTEXT_SPAN_KEY = Span.class.getName();
    static final String CONTEXT_SPAN_IN_SCOPE_KEY = Tracer.SpanInScope.class.getName();
    private static final Propagation.Getter<JobDataMap, String> GETTER = (carrier, key) -> {
        Object value = carrier.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    };
    private final Tracing tracing;

    TracingJobListener(Tracing tracing) {
        this.tracing = tracing;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        TraceContextOrSamplingFlags extracted = this.tracing.propagation().extractor(GETTER).extract((Object)context.getMergedJobDataMap());
        Span span = this.tracing.tracer().nextSpan(extracted).name(context.getTrigger().getJobKey().toString()).tag(TRIGGER_TAG_KEY, context.getTrigger().getKey().toString());
        context.put((Object)CONTEXT_SPAN_KEY, (Object)span);
        context.put((Object)CONTEXT_SPAN_IN_SCOPE_KEY, (Object)this.tracing.tracer().withSpanInScope(span.start()));
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        return false;
    }

    public void triggerMisfired(Trigger trigger) {
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        this.closeTrace(context);
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        this.closeTrace(context);
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
    }

    private void closeTrace(JobExecutionContext context) {
        Object spanInScope = context.get((Object)CONTEXT_SPAN_IN_SCOPE_KEY);
        Object span = context.get((Object)CONTEXT_SPAN_KEY);
        if (spanInScope instanceof Tracer.SpanInScope) {
            ((Tracer.SpanInScope)spanInScope).close();
        }
        if (span instanceof Span) {
            ((Span)span).finish();
        }
    }
}

