/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Span;
import brave.Tracing;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.reactor.LazySpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscriptionProvider;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public abstract class ReactorSleuth {
    private static final Log log = LogFactory.getLog(ReactorSleuth.class);
    private static Map<BeanFactory, Tracing> CACHE = new ConcurrentHashMap<BeanFactory, Tracing>();

    private ReactorSleuth() {
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> scopePassingSpanOperator(BeanFactory beanFactory) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scope passing operator [" + beanFactory + "]"));
        }
        BooleanSupplier isActive = beanFactory instanceof ConfigurableApplicationContext ? () -> ((ConfigurableApplicationContext)((ConfigurableApplicationContext)beanFactory)).isActive() : () -> true;
        return Operators.liftPublisher((p, sub) -> {
            if (p instanceof Fuseable.ScalarCallable) {
                return sub;
            }
            Scannable scannable = Scannable.from((Object)p);
            if (isActive.getAsBoolean()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Spring Context [" + beanFactory + "] already refreshed. Creating a scope passing span subscriber with Reactor Context [" + sub.currentContext() + "] and name [" + scannable.name() + "]"));
                }
                return ReactorSleuth.scopePassingSpanSubscription(beanFactory, sub);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring Context [" + beanFactory + "] is not yet refreshed, falling back to lazy span subscriber. Reactor Context is [" + sub.currentContext() + "] and name is [" + scannable.name() + "]"));
            }
            return new LazySpanSubscriber(ReactorSleuth.lazyScopePassingSpanSubscription(beanFactory, scannable, sub));
        });
    }

    static <T> SpanSubscriptionProvider<T> lazyScopePassingSpanSubscription(BeanFactory beanFactory, Scannable scannable, CoreSubscriber<? super T> sub) {
        return new SpanSubscriptionProvider<T>(beanFactory, sub, sub.currentContext(), scannable.name());
    }

    static <T> CoreSubscriber<? super T> scopePassingSpanSubscription(BeanFactory beanFactory, CoreSubscriber<? super T> sub) {
        Span root;
        Tracing tracing = CACHE.computeIfAbsent(beanFactory, beanFactory1 -> (Tracing)beanFactory1.getBean(Tracing.class));
        Context context = sub.currentContext();
        Span span = root = context.hasKey(Span.class) ? (Span)context.get(Span.class) : tracing.tracer().currentSpan();
        if (root != null) {
            return new ScopePassingSpanSubscriber<T>(sub, context, tracing, root);
        }
        return sub;
    }
}

