/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Span;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.core.Scannable;
import reactor.util.context.Context;

final class ScopePassingSpanSubscriber<T>
implements SpanSubscription<T>,
Scannable {
    private static final Log log = LogFactory.getLog(ScopePassingSpanSubscriber.class);
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private final CurrentTraceContext currentTraceContext;
    private final TraceContext traceContext;
    private Subscription s;

    ScopePassingSpanSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracing tracing, @Nullable Span root) {
        this.subscriber = subscriber;
        this.currentTraceContext = tracing.currentTraceContext();
        TraceContext traceContext = this.traceContext = root == null ? null : root.context();
        Context context = ctx != null && root != null ? ctx.put(Span.class, (Object)root) : (this.context = ctx != null ? ctx : Context.empty());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Root span [" + root + "], context [" + this.context + "]"));
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.s = subscription;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.traceContext);){
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public void request(long n) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.traceContext);){
            this.s.request(n);
        }
    }

    public void cancel() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.traceContext);){
            this.s.cancel();
        }
    }

    public void onNext(T o) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.traceContext);){
            this.subscriber.onNext(o);
        }
    }

    public void onError(Throwable throwable) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.traceContext);){
            this.subscriber.onError(throwable);
        }
    }

    public void onComplete() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.traceContext);){
            this.subscriber.onComplete();
        }
    }

    public Context currentContext() {
        return this.context;
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        return key == Scannable.Attr.ACTUAL ? this.subscriber : null;
    }
}

