/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.servlet.TracingFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.BeanFactory;

final class LazyTracingFilter
implements Filter {
    private final BeanFactory beanFactory;
    private Filter tracingFilter;

    LazyTracingFilter(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tracingFilter().init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.tracingFilter().doFilter(request, response, chain);
    }

    public void destroy() {
        this.tracingFilter().destroy();
    }

    private Filter tracingFilter() {
        if (this.tracingFilter == null) {
            this.tracingFilter = (Filter)this.beanFactory.getBean(TracingFilter.class);
        }
        return this.tracingFilter;
    }
}

