/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.servlet.HttpServletAdapter;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;

class TracePostZuulFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(TracePostZuulFilter.class);
    private final HttpServerHandler handler;
    private final Tracer tracer;

    TracePostZuulFilter(HttpTracing httpTracing) {
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)new HttpServletAdapter());
        this.tracer = httpTracing.tracing().tracer();
    }

    public boolean shouldFilter() {
        return !this.httpStatusSuccessful(RequestContext.getCurrentContext().getResponse());
    }

    private boolean httpStatusSuccessful(HttpServletResponse response) {
        if (response.getStatus() == 0) {
            return false;
        }
        HttpStatus.Series httpStatusSeries = HttpStatus.Series.valueOf((int)response.getStatus());
        return httpStatusSeries == HttpStatus.Series.SUCCESSFUL || httpStatusSeries == HttpStatus.Series.REDIRECTION;
    }

    public Object run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marking current span as handled");
        }
        HttpServletResponse response = RequestContext.getCurrentContext().getResponse();
        Throwable exception = RequestContext.getCurrentContext().getThrowable();
        Span currentSpan = this.tracer.currentSpan();
        this.handler.handleSend((Object)response, exception, currentSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handled send of " + currentSpan));
        }
        return null;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }
}

