/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.annotation.TagValueExpressionResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

class SpelTagValueExpressionResolver
implements TagValueExpressionResolver {
    private static final Log log = LogFactory.getLog(SpelTagValueExpressionResolver.class);

    SpelTagValueExpressionResolver() {
    }

    @Override
    public String resolve(String expression, Object parameter) {
        try {
            SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().build();
            SpelExpressionParser expressionParser = new SpelExpressionParser();
            Expression expressionToEvaluate = expressionParser.parseExpression(expression);
            return (String)expressionToEvaluate.getValue((EvaluationContext)context, parameter, String.class);
        }
        catch (Exception ex) {
            log.error((Object)("Exception occurred while tying to evaluate the SPEL expression [" + expression + "]"), (Throwable)ex);
            return parameter.toString();
        }
    }
}

