/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.Tracing;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.internal.ContextUtil;

public class LazyTraceExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(LazyTraceExecutor.class);
    private final BeanFactory beanFactory;
    private final Executor delegate;
    private Tracing tracing;
    private SpanNamer spanNamer;

    public LazyTraceExecutor(BeanFactory beanFactory, Executor delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            this.delegate.execute(command);
            return;
        }
        if (this.tracing == null) {
            try {
                this.tracing = (Tracing)this.beanFactory.getBean(Tracing.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.delegate.execute(command);
                return;
            }
        }
        this.delegate.execute(new TraceRunnable(this.tracing, this.spanNamer(), command));
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

