/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

public class SleuthContextListener
implements SmartApplicationListener {
    static final Map<BeanFactory, SleuthContextListener> CACHE = new ConcurrentHashMap<BeanFactory, SleuthContextListener>();
    private static final Log log = LogFactory.getLog(SleuthContextListener.class);
    final AtomicBoolean refreshed;
    final AtomicBoolean closed;

    public SleuthContextListener() {
        this.refreshed = new AtomicBoolean();
        this.closed = new AtomicBoolean();
    }

    SleuthContextListener(AtomicBoolean refreshed, AtomicBoolean closed) {
        this.refreshed = refreshed;
        this.closed = closed;
    }

    public static SleuthContextListener getBean(BeanFactory beanFactory) {
        return CACHE.getOrDefault(beanFactory, new SleuthContextListener());
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ContextClosedEvent.class.isAssignableFrom(eventType) || ContextRefreshedEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent || event instanceof ContextClosedEvent) {
            ApplicationContext context;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Context refreshed or closed [" + event + "]"));
            }
            ApplicationContextEvent contextEvent = (ApplicationContextEvent)event;
            ApplicationContext beanFactory = context = contextEvent.getApplicationContext();
            if (context instanceof ConfigurableApplicationContext) {
                beanFactory = ((ConfigurableApplicationContext)context).getBeanFactory();
            }
            SleuthContextListener listener = CACHE.getOrDefault(beanFactory, this);
            listener.refreshed.compareAndSet(false, event instanceof ContextRefreshedEvent);
            listener.closed.compareAndSet(false, event instanceof ContextClosedEvent);
            CACHE.put((BeanFactory)beanFactory, listener);
        }
    }

    public boolean isUnusable() {
        return !this.refreshed.get() || this.closed.get();
    }
}

