/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.sleuth.log.slf4j")
public class SleuthSlf4jProperties {
    private static final Log log = LogFactory.getLog(SleuthSlf4jProperties.class);
    private boolean enabled = true;
    @Deprecated
    private List<String> whitelistedMdcKeys = new ArrayList<String>();

    public boolean isEnabled() {
        this.warning("spring.sleuth.log.slf4j.enabled", "spring.sleuth.baggage.correlation-enabled");
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getWhitelistedMdcKeys() {
        return this.whitelistedMdcKeys;
    }

    public void setWhitelistedMdcKeys(List<String> whitelistedMdcKeys) {
        this.warning("spring.sleuth.log.slf4j.whitelisted-mdc-keys", "spring.sleuth.baggage.correlation-fields");
        this.whitelistedMdcKeys = whitelistedMdcKeys;
    }

    private void warning(String currentKey, String newKey) {
        log.warn((Object)("The [" + currentKey + "] property is deprecated and is removed in the next major release version of Sleuth. Please use [" + newKey + "]"));
    }
}

