/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.configuration;

import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.util.StringUtils;

public class ConfigurationFactoryBean
implements BeanClassLoaderAware,
InitializingBean,
FactoryBean<Configuration> {
    private static final Log log = LogFactory.getLog(ConfigurationFactoryBean.class);
    public static final String USERKEYTAB = "spring.hadoop.userKeytab";
    public static final String USERPRINCIPAL = "spring.hadoop.userPrincipal";
    private Configuration internalConfig;
    private Configuration configuration;
    private boolean loadDefaults = true;
    private Set<Resource> resources;
    private Properties properties;
    private ClassLoader beanClassLoader = this.getClass().getClassLoader();
    private boolean initialize = true;
    private boolean registerJvmUrl = false;
    private String fsUri;
    private String rmUri;
    private String jhUri;
    private String userKeytab;
    private String userPrincipal;
    private String namenodePrincipal;
    private String rmManagerPrincipal;
    private String securityMethod;

    public void afterPropertiesSet() throws Exception {
        this.internalConfig = this.createConfiguration(this.configuration);
        this.internalConfig.setClassLoader(this.beanClassLoader);
        if (this.resources != null) {
            for (Resource resource : this.resources) {
                this.internalConfig.addResource(resource.getURL());
            }
        }
        ConfigurationUtils.addProperties(this.internalConfig, this.properties);
        if (StringUtils.hasText((String)this.fsUri)) {
            this.internalConfig.set("fs.defaultFS", this.fsUri.trim());
        }
        if (StringUtils.hasText((String)this.rmUri)) {
            this.internalConfig.set("yarn.resourcemanager.address", this.rmUri.trim());
        }
        if (StringUtils.hasText((String)this.jhUri)) {
            this.internalConfig.set("mapreduce.jobhistory.address", this.jhUri.trim());
        }
        if (StringUtils.hasText((String)this.userKeytab)) {
            this.internalConfig.set(USERKEYTAB, this.userKeytab.trim());
        }
        if (StringUtils.hasText((String)this.userPrincipal)) {
            this.internalConfig.set(USERPRINCIPAL, this.userPrincipal.trim());
        }
        if (StringUtils.hasText((String)this.securityMethod)) {
            this.internalConfig.setBoolean("hadoop.security.authorization", true);
            this.internalConfig.set("hadoop.security.authentication", this.securityMethod);
            this.internalConfig.set("dfs.namenode.kerberos.principal", this.namenodePrincipal);
            this.internalConfig.set("yarn.resourcemanager.principal", this.rmManagerPrincipal);
            UserGroupInformation.setConfiguration((Configuration)this.internalConfig);
            if (StringUtils.hasText((String)this.userKeytab) && StringUtils.hasText((String)this.userPrincipal)) {
                try {
                    SecurityUtil.login((Configuration)this.internalConfig, (String)USERKEYTAB, (String)USERPRINCIPAL);
                }
                catch (Exception e) {
                    log.warn((Object)("Cannot login using keytab " + this.userKeytab + " and principal " + this.userPrincipal), (Throwable)e);
                }
            }
        }
        if (this.initialize) {
            this.internalConfig.size();
        }
        this.postProcessConfiguration(this.internalConfig);
        if (this.registerJvmUrl) {
            try {
                UserGroupInformation.setConfiguration((Configuration)this.internalConfig);
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory(this.getObject()));
                log.info((Object)"Registered HDFS URL stream handler");
            }
            catch (Error err) {
                log.warn((Object)"Cannot register Hadoop URL stream handler - one is already registered");
            }
        }
    }

    public void setSecurityMethod(String securityMethod) {
        this.securityMethod = securityMethod;
    }

    public Configuration getObject() {
        return this.internalConfig;
    }

    public Class<?> getObjectType() {
        return this.internalConfig != null ? this.internalConfig.getClass() : Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setUserKeytab(String userKeytab) {
        this.userKeytab = userKeytab;
    }

    public void setUserPrincipal(String userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public void setNamenodePrincipal(String namenodePrincipal) {
        this.namenodePrincipal = namenodePrincipal;
    }

    public void setRmManagerPrincipal(String rmManagerPrincipal) {
        this.rmManagerPrincipal = rmManagerPrincipal;
    }

    protected Configuration createConfiguration(Configuration existing) {
        return existing != null ? new Configuration(existing) : new Configuration(this.loadDefaults);
    }

    protected void postProcessConfiguration(Configuration configuration) {
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setLoadDefaults(boolean loadDefaults) {
        this.loadDefaults = loadDefaults;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public void setRegisterUrlHandler(boolean register) {
        this.registerJvmUrl = register;
    }

    public void setFileSystemUri(String fsUri) {
        this.fsUri = fsUri;
    }

    public void setRmManagerUri(String rmUri) {
        this.rmUri = rmUri;
    }

    public void setJobHistoryUri(String jhUri) {
        this.jhUri = jhUri;
    }
}

