/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.configuration;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

public abstract class JobConfUtils {
    public static JobConf createFrom(Configuration original, Properties properties) {
        JobConf cfg = null;
        cfg = original != null ? new JobConf(original) : new JobConf();
        ConfigurationUtils.addProperties((Configuration)cfg, properties);
        return cfg;
    }

    public static JobConf merge(Configuration one, Configuration two) {
        if (one == null) {
            if (two == null) {
                return new JobConf();
            }
            return new JobConf(two);
        }
        JobConf c = new JobConf(one);
        if (two == null) {
            return c;
        }
        for (Map.Entry entry : two) {
            c.set((String)entry.getKey(), (String)entry.getValue());
        }
        return c;
    }
}

