/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.fs.HdfsResource;
import org.springframework.data.hadoop.fs.HdfsResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DistributedCacheFactoryBean
implements InitializingBean,
FactoryBean<DistributedCache> {
    private static boolean FILE_SEPARATOR_WARNING = true;
    private Configuration conf;
    private DistributedCache ds;
    private FileSystem fs;
    private boolean createSymlink = false;
    private Collection<CacheEntry> entries;

    public DistributedCache getObject() throws Exception {
        return this.ds;
    }

    public Class<?> getObjectType() {
        return DistributedCache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.conf, (String)"A Hadoop configuration is required");
        Assert.notEmpty(this.entries, (String)"No entries specified");
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)this.conf);
        }
        this.ds = new DistributedCache();
        if (this.createSymlink) {
            DistributedCache.createSymlink((Configuration)this.conf);
        }
        boolean warnCpEntry = !":".equals(System.getProperty("path.separator"));
        try (HdfsResourceLoader loader = new HdfsResourceLoader(this.fs);){
            for (CacheEntry entry : this.entries) {
                Object[] resources = loader.getResources(entry.value);
                if (ObjectUtils.isEmpty((Object[])resources)) continue;
                block9: for (Object resource : resources) {
                    HdfsResource res = (HdfsResource)resource;
                    URI uri = res.getURI();
                    String path = DistributedCacheFactoryBean.getPathWithFragment(uri);
                    String defaultLink = resource.getFilename();
                    boolean isArchive = defaultLink.endsWith(".tgz") || defaultLink.endsWith(".tar") || defaultLink.endsWith(".tar.gz") || defaultLink.endsWith(".zip");
                    switch (entry.type) {
                        case CP: {
                            Path p = new Path(URI.create(path));
                            if (FILE_SEPARATOR_WARNING && warnCpEntry) {
                                LogFactory.getLog(DistributedCacheFactoryBean.class).warn((Object)"System path separator is not ':' - this will likely cause invalid classpath entries within the DistributedCache. See the docs and HADOOP-9123 for more information.");
                                FILE_SEPARATOR_WARNING = false;
                            }
                            if (isArchive) {
                                DistributedCache.addArchiveToClassPath((Path)p, (Configuration)this.conf, (FileSystem)this.fs);
                                continue block9;
                            }
                            DistributedCache.addFileToClassPath((Path)p, (Configuration)this.conf, (FileSystem)this.fs);
                            continue block9;
                        }
                        case LOCAL: {
                            continue block9;
                        }
                        case CACHE: {
                            if (!path.contains("#")) {
                                uri = URI.create(path + "#" + defaultLink);
                            }
                            if (isArchive) {
                                DistributedCache.addCacheArchive((URI)uri, (Configuration)this.conf);
                                continue block9;
                            }
                            DistributedCache.addCacheFile((URI)uri, (Configuration)this.conf);
                        }
                    }
                }
            }
        }
    }

    public void setEntries(Collection<CacheEntry> entries) {
        this.entries = entries;
    }

    public void setLocalEntries(Collection<Resource> resources) {
        this.setEntries(CacheEntry.EntryType.LOCAL, resources);
    }

    public void setCacheEntries(Collection<Resource> resources) {
        this.setEntries(CacheEntry.EntryType.CACHE, resources);
    }

    public void setClassPathEntries(Collection<Resource> resources) {
        this.setEntries(CacheEntry.EntryType.CP, resources);
    }

    private void setEntries(CacheEntry.EntryType cp, Collection<Resource> resources) {
        if (resources == null) {
            this.setEntries(null);
        } else {
            ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>(resources.size());
            for (Resource resource : resources) {
                try {
                    entries.add(new CacheEntry(cp, resource.getURI().toString()));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Cannot resolve resource " + resource, ex);
                }
            }
            this.setEntries(entries);
        }
    }

    public void setConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    public void setCreateSymlink(boolean createSymlink) {
        this.createSymlink = createSymlink;
    }

    private static String getPathWithFragment(URI uri) {
        String path = uri.getPath();
        String fragment = uri.getFragment();
        if (StringUtils.hasText((String)fragment)) {
            path = path + "#" + fragment;
        }
        return path;
    }

    public static class CacheEntry {
        final EntryType type;
        final String value;

        public CacheEntry(EntryType type, String value) {
            this.type = type;
            this.value = value;
        }

        public static enum EntryType {
            LOCAL,
            CACHE,
            CP;

        }
    }
}

