/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;

class TextRecordInputStream
extends InputStream {
    SequenceFile.Reader r;
    WritableComparable<?> key;
    Writable val;
    DataInputBuffer inbuf;
    DataOutputBuffer outbuf;

    public TextRecordInputStream(Path p, FileSystem fs, Configuration configuration) throws IOException {
        this.r = new SequenceFile.Reader(fs, p, configuration);
        this.key = (WritableComparable)ReflectionUtils.newInstance(this.r.getKeyClass().asSubclass(WritableComparable.class), (Configuration)configuration);
        this.val = (Writable)ReflectionUtils.newInstance(this.r.getValueClass().asSubclass(Writable.class), (Configuration)configuration);
        this.inbuf = new DataInputBuffer();
        this.outbuf = new DataOutputBuffer();
    }

    @Override
    public int read() throws IOException {
        int ret;
        if (null == this.inbuf || -1 == (ret = this.inbuf.read())) {
            if (!this.r.next(this.key, this.val)) {
                return -1;
            }
            byte[] tmp = this.key.toString().getBytes();
            this.outbuf.write(tmp, 0, tmp.length);
            this.outbuf.write(9);
            tmp = this.val.toString().getBytes();
            this.outbuf.write(tmp, 0, tmp.length);
            this.outbuf.write(10);
            this.inbuf.reset(this.outbuf.getData(), this.outbuf.getLength());
            this.outbuf.reset();
            ret = this.inbuf.read();
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.r.close();
        super.close();
    }
}

