/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.configuration.JobConfUtils;
import org.springframework.data.hadoop.mapreduce.ExecutionUtils;
import org.springframework.data.hadoop.mapreduce.JobGenericOptions;
import org.springframework.data.hadoop.mapreduce.ParentLastURLClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

abstract class HadoopCodeExecutor<T>
extends JobGenericOptions
implements InitializingBean,
BeanClassLoaderAware {
    String[] arguments;
    Configuration configuration;
    T target;
    String targetClassName;
    Properties properties;
    Resource jar;
    private ClassLoader beanClassLoader;
    private boolean closeFs = true;

    HadoopCodeExecutor() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.target != null || StringUtils.hasText((String)this.targetClassName) || this.jar != null && this.jar.exists() ? 1 : 0) != 0, (String)"a target instance, class name or a Jar (with Main-Class) is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int runCode() throws Exception {
        final Configuration cfg = this.resolveConfiguration();
        final Class<T> type = this.resolveTargetClass(cfg);
        final T target = this.resolveTargetObject(type);
        Thread th = Thread.currentThread();
        ClassLoader oldTccl = th.getContextClassLoader();
        this.log.info((Object)("Invoking [" + (target != null ? target : type) + "] " + (this.jar != null ? "from jar [" + this.jar.getURI() + "]" : "") + " with args [" + Arrays.toString(this.arguments) + "]"));
        ClassLoader newCL = cfg.getClassLoader();
        boolean isJarCL = newCL instanceof ParentLastURLClassLoader;
        try {
            ExecutionUtils.disableSystemExitCall();
            if (isJarCL) {
                ExecutionUtils.preventHadoopLeaks(this.beanClassLoader);
            }
            th.setContextClassLoader(newCL);
            if (StringUtils.hasText((String)this.user)) {
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)this.user, (UserGroupInformation)UserGroupInformation.getLoginUser());
                int n = (Integer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws Exception {
                        return HadoopCodeExecutor.this.invokeTarget(cfg, target, type, HadoopCodeExecutor.this.arguments);
                    }
                });
                return n;
            }
            int n = this.invokeTarget(cfg, target, type, this.arguments);
            return n;
        }
        finally {
            ExecutionUtils.enableSystemExitCall();
            th.setContextClassLoader(oldTccl);
            if (isJarCL) {
                if (this.closeFs) {
                    ExecutionUtils.shutdownFileSystem(cfg);
                }
                ExecutionUtils.patchLeakedClassLoader(newCL, oldTccl);
            }
        }
    }

    protected Configuration resolveConfiguration() throws Exception {
        JobConf cfg = JobConfUtils.createFrom(this.configuration, this.properties);
        if (this.jar != null) {
            String jarUrl = this.jar.getURL().toString();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Setting Configuration Jar URL to [" + jarUrl + "]"));
            }
            cfg.set("mapred.jar", jarUrl);
        }
        this.buildGenericOptions((Configuration)cfg);
        return cfg;
    }

    protected Class<T> resolveTargetClass(Configuration cfg) throws Exception {
        ClassLoader cl = this.beanClassLoader;
        if (this.target == null) {
            cl = this.createClassLoaderForJar(this.jar, cl, cfg);
            cfg.setClassLoader(cl);
            if (this.jar != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Creating custom classloader " + cl));
                }
                if (!StringUtils.hasText((String)this.targetClassName)) {
                    String mainClass = ExecutionUtils.mainClass(this.jar);
                    Assert.notNull((Object)mainClass, (String)"no target class specified and no Main-Class available");
                    this.targetClassName = mainClass;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Discovered Main-Class [" + mainClass + "]"));
                    }
                }
            } else {
                Assert.hasText((String)this.targetClassName, (String)"No target object, class or jar specified - execution aborted");
            }
            return this.loadClass(this.targetClassName, cl);
        }
        return this.target.getClass();
    }

    protected T resolveTargetObject(Class<T> type) {
        return (T)(this.target != null ? this.target : BeanUtils.instantiateClass(type));
    }

    protected ClassLoader createClassLoaderForJar(Resource jar, ClassLoader parentCL, Configuration cfg) {
        return ExecutionUtils.createParentLastClassLoader(jar, parentCL, cfg);
    }

    protected Class<T> loadClass(String className, ClassLoader cl) {
        return ClassUtils.resolveClassName((String)className, (ClassLoader)cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer invokeTarget(Configuration cfg, T target, Class<T> targetClass, String[] args) throws Exception {
        this.preExecution(cfg);
        try {
            Object result = this.invokeTargetObject(cfg, target, targetClass, args);
            if (result instanceof Integer) {
                Integer n = (Integer)result;
                return n;
            }
            Integer n = 0;
            return n;
        }
        catch (ExecutionUtils.ExitTrapped trap) {
            this.log.debug((Object)"Code exited");
            Integer n = trap.getExitCode();
            return n;
        }
        finally {
            this.postExecution(cfg);
        }
    }

    protected void preExecution(Configuration cfg) {
    }

    protected void postExecution(Configuration cfg) {
    }

    protected abstract Object invokeTargetObject(Configuration var1, T var2, Class<T> var3, String[] var4) throws Exception;

    public void setJar(Resource jar) {
        this.jar = jar;
    }

    public void setArguments(String ... arguments) {
        this.arguments = arguments;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setCloseFs(boolean closeFs) {
        this.closeFs = closeFs;
    }

    void setTargetObject(T target) {
        Assert.isNull((Object)this.targetClassName, (String)"a target class already set");
        this.target = target;
    }

    void setTargetClassName(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    static {
        ExecutionUtils.preventJreTcclLeaks();
    }
}

