/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.springframework.data.hadoop.mapreduce.JobExecutor;

public class JobRunner
extends JobExecutor
implements Callable<Void> {
    private boolean runAtStartup = false;
    private Iterable<Callable<?>> preActions;
    private Iterable<Callable<?>> postActions;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.runAtStartup) {
            this.call();
        }
    }

    @Override
    public Void call() throws Exception {
        this.invoke(this.preActions);
        this.startJobs();
        this.invoke(this.postActions);
        return null;
    }

    public void setRunAtStartup(boolean runAtStartup) {
        this.runAtStartup = runAtStartup;
    }

    public void setPreAction(Collection<Callable<?>> actions) {
        this.preActions = actions;
    }

    public void setPostAction(Collection<Callable<?>> actions) {
        this.postActions = actions;
    }

    private void invoke(Iterable<Callable<?>> actions) throws Exception {
        if (actions != null) {
            for (Callable<?> action : actions) {
                action.call();
            }
        }
    }
}

